/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultBoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;

class DefaultBoundSetOperations<K, V>
extends DefaultBoundKeyOperations<K>
implements BoundSetOperations<K, V> {
    private final SetOperations<K, V> ops;

    DefaultBoundSetOperations(K key, RedisOperations<K, V> operations) {
        super(key, operations);
        this.ops = operations.opsForSet();
    }

    @Override
    public Long add(V ... values) {
        return this.ops.add(this.getKey(), values);
    }

    @Override
    public Set<V> diff(K key) {
        return this.ops.difference(this.getKey(), key);
    }

    @Override
    public Set<V> diff(Collection<K> keys) {
        return this.ops.difference(this.getKey(), keys);
    }

    @Override
    public void diffAndStore(K key, K destKey) {
        this.ops.differenceAndStore(this.getKey(), key, destKey);
    }

    @Override
    public void diffAndStore(Collection<K> keys, K destKey) {
        this.ops.differenceAndStore(this.getKey(), keys, destKey);
    }

    @Override
    public RedisOperations<K, V> getOperations() {
        return this.ops.getOperations();
    }

    @Override
    public Set<V> intersect(K key) {
        return this.ops.intersect(this.getKey(), key);
    }

    @Override
    public Set<V> intersect(Collection<K> keys) {
        return this.ops.intersect(this.getKey(), keys);
    }

    @Override
    public void intersectAndStore(K key, K destKey) {
        this.ops.intersectAndStore(this.getKey(), key, destKey);
    }

    @Override
    public void intersectAndStore(Collection<K> keys, K destKey) {
        this.ops.intersectAndStore(this.getKey(), keys, destKey);
    }

    @Override
    public Boolean isMember(Object o) {
        return this.ops.isMember(this.getKey(), o);
    }

    @Override
    public Set<V> members() {
        return this.ops.members(this.getKey());
    }

    @Override
    public Boolean move(K destKey, V value) {
        return this.ops.move(this.getKey(), value, destKey);
    }

    @Override
    public V randomMember() {
        return this.ops.randomMember(this.getKey());
    }

    @Override
    public Set<V> distinctRandomMembers(long count) {
        return this.ops.distinctRandomMembers(this.getKey(), count);
    }

    @Override
    public List<V> randomMembers(long count) {
        return this.ops.randomMembers(this.getKey(), count);
    }

    @Override
    public Long remove(Object ... values) {
        return this.ops.remove(this.getKey(), values);
    }

    @Override
    public V pop() {
        return this.ops.pop(this.getKey());
    }

    @Override
    public Long size() {
        return this.ops.size(this.getKey());
    }

    @Override
    public Set<V> union(K key) {
        return this.ops.union(this.getKey(), key);
    }

    @Override
    public Set<V> union(Collection<K> keys) {
        return this.ops.union(this.getKey(), keys);
    }

    @Override
    public void unionAndStore(K key, K destKey) {
        this.ops.unionAndStore(this.getKey(), key, destKey);
    }

    @Override
    public void unionAndStore(Collection<K> keys, K destKey) {
        this.ops.unionAndStore(this.getKey(), keys, destKey);
    }

    @Override
    public DataType getType() {
        return DataType.SET;
    }

    @Override
    public Cursor<V> scan(ScanOptions options) {
        return this.ops.scan(this.getKey(), options);
    }
}

