/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;

class LettuceStringCommands
implements RedisStringCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public byte[] get(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().get((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().get((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().get((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().getset((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().getset((Object)key, (Object)value)));
                return null;
            }
            return (byte[])this.getConnection().getset((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().mget((Object[])keys), LettuceConverters.keyValueListUnwrapper()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().mget((Object[])keys), LettuceConverters.keyValueListUnwrapper()));
                return null;
            }
            return LettuceConverters.keyValueListUnwrapper().convert(this.getConnection().mget((Object[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean set(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().set((Object)key, (Object)value), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().set((Object)key, (Object)value), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.getConnection().set((Object)key, (Object)value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null!");
        Assert.notNull((Object)((Object)option), (String)"Option must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().set((Object)key, (Object)value, LettuceConverters.toSetArgs(expiration, option)), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().set((Object)key, (Object)value, LettuceConverters.toSetArgs(expiration, option)), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.getConnection().set((Object)key, (Object)value, LettuceConverters.toSetArgs(expiration, option)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().setnx((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().setnx((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().setnx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().setex((Object)key, seconds, (Object)value), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().setex((Object)key, seconds, (Object)value), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.getConnection().setex((Object)key, seconds, (Object)value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().psetex((Object)key, milliseconds, (Object)value), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().psetex((Object)key, milliseconds, (Object)value), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.getConnection().psetex((Object)key, milliseconds, (Object)value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean mSet(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().mset(tuples), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().mset(tuples), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.getConnection().mset(tuples));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().msetnx(tuples)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().msetnx(tuples)));
                return null;
            }
            return this.getConnection().msetnx(tuples);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().incr((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().incr((Object)key)));
                return null;
            }
            return this.getConnection().incr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().incrby((Object)key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().incrby((Object)key, value)));
                return null;
            }
            return this.getConnection().incrby((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().incrbyfloat((Object)key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().incrbyfloat((Object)key, value)));
                return null;
            }
            return this.getConnection().incrbyfloat((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().decr((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().decr((Object)key)));
                return null;
            }
            return this.getConnection().decr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().decrby((Object)key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().decrby((Object)key, value)));
                return null;
            }
            return this.getConnection().decrby((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().append((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().append((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().append((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().getrange((Object)key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().getrange((Object)key, start, end)));
                return null;
            }
            return (byte[])this.getConnection().getrange((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long offset) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult((Future<?>)this.getAsyncConnection().setrange((Object)key, offset, (Object)value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxStatusResult(this.getConnection().setrange((Object)key, offset, (Object)value)));
                return;
            }
            this.getConnection().setrange((Object)key, offset, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().getbit((Object)key, offset), LettuceConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().getbit((Object)key, offset), LettuceConverters.longToBoolean()));
                return null;
            }
            return LettuceConverters.toBoolean(this.getConnection().getbit((Object)key, offset));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().setbit((Object)key, offset, LettuceConverters.toInt(value)), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().setbit((Object)key, offset, LettuceConverters.toInt(value)), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            return (Boolean)LettuceConverters.longToBooleanConverter().convert((Object)this.getConnection().setbit((Object)key, offset, LettuceConverters.toInt(value)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().bitcount((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().bitcount((Object)key)));
                return null;
            }
            return this.getConnection().bitcount((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().bitcount((Object)key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().bitcount((Object)key, start, end)));
                return null;
            }
            return this.getConnection().bitcount((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        Assert.notNull((Object)((Object)op), (String)"BitOperation must not be null!");
        Assert.notNull((Object)destination, (String)"Destination key must not be null!");
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.asyncBitOp(op, destination, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.syncBitOp(op, destination, keys)));
                return null;
            }
            return this.syncBitOp(op, destination, keys);
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private Future<Long> asyncBitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        switch (op) {
            case AND: {
                return this.getAsyncConnection().bitopAnd((Object)destination, (Object[])keys);
            }
            case OR: {
                return this.getAsyncConnection().bitopOr((Object)destination, (Object[])keys);
            }
            case XOR: {
                return this.getAsyncConnection().bitopXor((Object)destination, (Object[])keys);
            }
            case NOT: {
                if (keys.length != 1) {
                    throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
                }
                return this.getAsyncConnection().bitopNot((Object)destination, (Object)keys[0]);
            }
        }
        throw new UnsupportedOperationException("Bit operation " + (Object)((Object)op) + " is not supported");
    }

    private Long syncBitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        switch (op) {
            case AND: {
                return this.getConnection().bitopAnd((Object)destination, (Object[])keys);
            }
            case OR: {
                return this.getConnection().bitopOr((Object)destination, (Object[])keys);
            }
            case XOR: {
                return this.getConnection().bitopXor((Object)destination, (Object[])keys);
            }
            case NOT: {
                if (keys.length != 1) {
                    throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
                }
                return this.getConnection().bitopNot((Object)destination, (Object)keys[0]);
            }
        }
        throw new UnsupportedOperationException("Bit operation " + (Object)((Object)op) + " is not supported");
    }

    @Override
    public Long strLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().strlen((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().strlen((Object)key)));
                return null;
            }
            return this.getConnection().strlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceConnection.LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceConnection.LettuceTxResult result) {
        this.connection.transaction(result);
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    @ConstructorProperties(value={"connection"})
    public LettuceStringCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

