/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;

public class DefaultGeoOperations<K, M>
extends AbstractOperations<K, M>
implements GeoOperations<K, M> {
    DefaultGeoOperations(RedisTemplate<K, M> template) {
        super(template);
    }

    @Override
    public Long geoAdd(K key, final Point point, M member) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawMember = this.rawValue(member);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.geoAdd(rawKey, point, rawMember);
            }
        }, true);
    }

    @Override
    public Long geoAdd(K key, RedisGeoCommands.GeoLocation<M> location) {
        return this.geoAdd(key, location.getPoint(), location.getName());
    }

    @Override
    public Long geoAdd(K key, Map<M, Point> memberCoordinateMap) {
        final byte[] rawKey = this.rawKey(key);
        final HashMap<byte[], Point> rawMemberCoordinateMap = new HashMap<byte[], Point>();
        for (M member : memberCoordinateMap.keySet()) {
            byte[] rawMember = this.rawValue(member);
            rawMemberCoordinateMap.put(rawMember, memberCoordinateMap.get(member));
        }
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.geoAdd(rawKey, rawMemberCoordinateMap);
            }
        }, true);
    }

    @Override
    public Long geoAdd(K key, Iterable<RedisGeoCommands.GeoLocation<M>> locations) {
        LinkedHashMap<M, Point> memberCoordinateMap = new LinkedHashMap<M, Point>();
        for (RedisGeoCommands.GeoLocation<M> location : locations) {
            memberCoordinateMap.put(location.getName(), location.getPoint());
        }
        return this.geoAdd(key, memberCoordinateMap);
    }

    @Override
    public Distance geoDist(K key, M member1, M member2) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawMember1 = this.rawValue(member1);
        final byte[] rawMember2 = this.rawValue(member2);
        return this.execute(new RedisCallback<Distance>(){

            @Override
            public Distance doInRedis(RedisConnection connection) {
                return connection.geoDist(rawKey, rawMember1, rawMember2);
            }
        }, true);
    }

    @Override
    public Distance geoDist(K key, M member1, M member2, final Metric metric) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawMember1 = this.rawValue(member1);
        final byte[] rawMember2 = this.rawValue(member2);
        return this.execute(new RedisCallback<Distance>(){

            @Override
            public Distance doInRedis(RedisConnection connection) {
                return connection.geoDist(rawKey, rawMember1, rawMember2, metric);
            }
        }, true);
    }

    @Override
    public List<String> geoHash(K key, M ... members) {
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawMembers = this.rawValues(members);
        return this.execute(new RedisCallback<List<String>>(){

            @Override
            public List<String> doInRedis(RedisConnection connection) {
                return connection.geoHash(rawKey, rawMembers);
            }
        }, true);
    }

    @Override
    public List<Point> geoPos(K key, M ... members) {
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawMembers = this.rawValues(members);
        return this.execute(new RedisCallback<List<Point>>(){

            @Override
            public List<Point> doInRedis(RedisConnection connection) {
                return connection.geoPos(rawKey, rawMembers);
            }
        }, true);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadius(K key, final Circle within) {
        final byte[] rawKey = this.rawKey(key);
        GeoResults<RedisGeoCommands.GeoLocation<byte[]>> raw = this.execute(new RedisCallback<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>>(){

            @Override
            public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> doInRedis(RedisConnection connection) {
                return connection.geoRadius(rawKey, within);
            }
        }, true);
        return this.deserializeGeoResults(raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadius(K key, final Circle within, final RedisGeoCommands.GeoRadiusCommandArgs args) {
        final byte[] rawKey = this.rawKey(key);
        GeoResults<RedisGeoCommands.GeoLocation<byte[]>> raw = this.execute(new RedisCallback<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>>(){

            @Override
            public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> doInRedis(RedisConnection connection) {
                return connection.geoRadius(rawKey, within, args);
            }
        }, true);
        return this.deserializeGeoResults(raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, final double radius) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawMember = this.rawValue(member);
        GeoResults<RedisGeoCommands.GeoLocation<byte[]>> raw = this.execute(new RedisCallback<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>>(){

            @Override
            public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> doInRedis(RedisConnection connection) {
                return connection.geoRadiusByMember(rawKey, rawMember, radius);
            }
        }, true);
        return this.deserializeGeoResults(raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, final Distance distance) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawMember = this.rawValue(member);
        GeoResults<RedisGeoCommands.GeoLocation<byte[]>> raw = this.execute(new RedisCallback<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>>(){

            @Override
            public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> doInRedis(RedisConnection connection) {
                return connection.geoRadiusByMember(rawKey, rawMember, distance);
            }
        }, true);
        return this.deserializeGeoResults(raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, final Distance distance, final RedisGeoCommands.GeoRadiusCommandArgs param) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawMember = this.rawValue(member);
        GeoResults<RedisGeoCommands.GeoLocation<byte[]>> raw = this.execute(new RedisCallback<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>>(){

            @Override
            public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> doInRedis(RedisConnection connection) {
                return connection.geoRadiusByMember(rawKey, rawMember, distance, param);
            }
        }, true);
        return this.deserializeGeoResults(raw);
    }

    @Override
    public Long geoRemove(K key, M ... members) {
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawMembers = this.rawValues(members);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.zRem(rawKey, rawMembers);
            }
        }, true);
    }
}

