/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.srp;

import java.util.ArrayList;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.connection.ReturnType;
import redis.reply.Reply;

public class SrpScriptReturnConverter
implements Converter<Object, Object> {
    private ReturnType returnType;

    public SrpScriptReturnConverter(ReturnType returnType) {
        this.returnType = returnType;
    }

    public Object convert(Object source) {
        if (this.returnType == ReturnType.MULTI) {
            Reply[] replies = (Reply[])source;
            ArrayList<Object> results = new ArrayList<Object>();
            for (Reply reply : replies) {
                results.add(reply.data());
            }
            return results;
        }
        if (this.returnType == ReturnType.BOOLEAN) {
            if (source == null) {
                return Boolean.FALSE;
            }
            return (Long)source == 1L;
        }
        return source;
    }
}

