/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.srp;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.srp.SrpConnection;
import org.springframework.data.redis.connection.srp.SrpConverters;

public class SrpConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    private String hostName = "localhost";
    private int port = 6379;
    private BlockingQueue<SrpConnection> trackedConnections = new ArrayBlockingQueue<SrpConnection>(50);
    private boolean convertPipelineAndTxResults = true;

    public SrpConnectionFactory() {
    }

    public SrpConnectionFactory(String host, int port) {
        this.hostName = host;
        this.port = port;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        SrpConnection con;
        do {
            if ((con = (SrpConnection)this.trackedConnections.poll()) == null || con.isClosed()) continue;
            try {
                con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (con != null);
    }

    public RedisConnection getConnection() {
        SrpConnection connection = new SrpConnection(this.hostName, this.port, this.trackedConnections);
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return connection;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return SrpConverters.toDataAccessException(ex);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }
}

