/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultHashOperations<K, HK, HV>
extends AbstractOperations<K, Object>
implements HashOperations<K, HK, HV> {
    DefaultHashOperations(RedisTemplate<K, ?> template) {
        super(template);
    }

    @Override
    public HV get(K key, Object hashKey) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawHashKey = this.rawHashKey(hashKey);
        byte[] rawHashValue = this.execute(new RedisCallback<byte[]>(){

            @Override
            public byte[] doInRedis(RedisConnection connection) {
                return connection.hGet(rawKey, rawHashKey);
            }
        }, true);
        return this.deserializeHashValue(rawHashValue);
    }

    @Override
    public Boolean hasKey(K key, Object hashKey) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.hExists(rawKey, rawHashKey);
            }
        }, true);
    }

    @Override
    public Long increment(K key, HK hashKey, final long delta) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.hIncrBy(rawKey, rawHashKey, delta);
            }
        }, true);
    }

    @Override
    public Double increment(K key, HK hashKey, final double delta) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(new RedisCallback<Double>(){

            @Override
            public Double doInRedis(RedisConnection connection) {
                return connection.hIncrBy(rawKey, rawHashKey, delta);
            }
        }, true);
    }

    @Override
    public Set<HK> keys(K key) {
        final byte[] rawKey = this.rawKey(key);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.hKeys(rawKey);
            }
        }, true);
        return this.deserializeHashKeys(rawValues);
    }

    @Override
    public Long size(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.hLen(rawKey);
            }
        }, true);
    }

    @Override
    public void putAll(K key, Map<? extends HK, ? extends HV> m) {
        if (m.isEmpty()) {
            return;
        }
        final byte[] rawKey = this.rawKey(key);
        final LinkedHashMap<byte[], byte[]> hashes = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<HK, HV> entry : m.entrySet()) {
            hashes.put(this.rawHashKey(entry.getKey()), this.rawHashValue(entry.getValue()));
        }
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.hMSet(rawKey, hashes);
                return null;
            }
        }, true);
    }

    @Override
    public List<HV> multiGet(K key, Collection<HK> fields) {
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawHashKeys = new byte[fields.size()][];
        int counter = 0;
        for (HK hashKey : fields) {
            rawHashKeys[counter++] = this.rawHashKey(hashKey);
        }
        List<byte[]> rawValues = this.execute(new RedisCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInRedis(RedisConnection connection) {
                return connection.hMGet(rawKey, rawHashKeys);
            }
        }, true);
        return this.deserializeHashValues(rawValues);
    }

    @Override
    public void put(K key, HK hashKey, HV value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawHashKey = this.rawHashKey(hashKey);
        final byte[] rawHashValue = this.rawHashValue(value);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.hSet(rawKey, rawHashKey, rawHashValue);
                return null;
            }
        }, true);
    }

    @Override
    public Boolean putIfAbsent(K key, HK hashKey, HV value) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawHashKey = this.rawHashKey(hashKey);
        final byte[] rawHashValue = this.rawHashValue(value);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.hSetNX(rawKey, rawHashKey, rawHashValue);
            }
        }, true);
    }

    @Override
    public List<HV> values(K key) {
        final byte[] rawKey = this.rawKey(key);
        List<byte[]> rawValues = this.execute(new RedisCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInRedis(RedisConnection connection) {
                return connection.hVals(rawKey);
            }
        }, true);
        return this.deserializeHashValues(rawValues);
    }

    @Override
    public void delete(K key, Object hashKey) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawHashKey = this.rawHashKey(hashKey);
        this.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) {
                connection.hDel(rawKey, rawHashKey);
                return null;
            }
        }, true);
    }

    @Override
    public Map<HK, HV> entries(K key) {
        final byte[] rawKey = this.rawKey(key);
        Map<byte[], byte[]> entries = this.execute(new RedisCallback<Map<byte[], byte[]>>(){

            @Override
            public Map<byte[], byte[]> doInRedis(RedisConnection connection) {
                return connection.hGetAll(rawKey);
            }
        }, true);
        return this.deserializeHashMap(entries);
    }
}

