/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jredis;

import java.util.Map;
import java.util.Properties;
import org.jredis.ClientRuntimeException;
import org.jredis.RedisException;
import org.jredis.RedisType;
import org.jredis.Sort;
import org.jredis.connector.NotConnectedException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.SortParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JredisUtils {
    public static DataAccessException convertJredisAccessException(RedisException ex) {
        return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
    }

    public static DataAccessException convertJredisAccessException(ClientRuntimeException ex) {
        if (ex instanceof NotConnectedException) {
            return new RedisConnectionFailureException(ex.getMessage(), (Throwable)ex);
        }
        return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
    }

    static DataType convertDataType(RedisType type) {
        switch (type) {
            case NONE: {
                return DataType.NONE;
            }
            case string: {
                return DataType.STRING;
            }
            case list: {
                return DataType.LIST;
            }
            case set: {
                return DataType.SET;
            }
            case hash: {
                return DataType.HASH;
            }
        }
        return null;
    }

    static Sort applySortingParams(Sort jredisSort, SortParameters params, byte[] storeKey) {
        if (params != null) {
            Boolean isAlpha;
            SortParameters.Order order;
            SortParameters.Range limit;
            byte[][] getPattern;
            byte[] byPattern = params.getByPattern();
            if (byPattern != null) {
                jredisSort.BY((Object)byPattern);
            }
            if ((getPattern = params.getGetPattern()) != null && getPattern.length > 0) {
                for (byte[] bs : getPattern) {
                    jredisSort.GET((Object)bs);
                }
            }
            if ((limit = params.getLimit()) != null) {
                jredisSort.LIMIT(limit.getStart(), limit.getCount());
            }
            if ((order = params.getOrder()) != null && order.equals((Object)SortParameters.Order.DESC)) {
                jredisSort.DESC();
            }
            if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
                jredisSort.ALPHA();
            }
        }
        if (storeKey != null) {
            jredisSort.STORE((Object)storeKey);
        }
        return jredisSort;
    }

    static Properties info(Map<String, String> map) {
        Properties info = new Properties();
        info.putAll(map);
        return info;
    }
}

