/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.connection.DefaultSortParameters;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.serializer.RedisSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryUtils {
    public static <K> SortParameters convertQuery(SortQuery<K> query, RedisSerializer<String> stringSerializer) {
        return new DefaultSortParameters(stringSerializer.serialize(query.getBy()), query.getLimit(), QueryUtils.serialize(query.getGetPattern(), stringSerializer), query.getOrder(), query.isAlphabetic());
    }

    private static byte[][] serialize(List<String> strings, RedisSerializer<String> stringSerializer) {
        List raw = null;
        if (strings == null) {
            raw = Collections.emptyList();
        } else {
            raw = new ArrayList(strings.size());
            for (String key : strings) {
                raw.add(stringSerializer.serialize(key));
            }
        }
        return (byte[][])raw.toArray((T[])new byte[raw.size()][]);
    }
}

