/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.support.collections.RedisStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CollectionUtils {
    CollectionUtils() {
    }

    static <E> Collection<E> reverse(Collection<? extends E> c) {
        Object[] reverse = new Object[c.size()];
        int index = c.size();
        for (E e : c) {
            reverse[--index] = e;
        }
        return Arrays.asList(reverse);
    }

    static Collection<String> extractKeys(Collection<? extends RedisStore> stores) {
        ArrayList<String> keys = new ArrayList<String>(stores.size());
        for (RedisStore redisStore : stores) {
            keys.add((String)redisStore.getKey());
        }
        return keys;
    }

    static <K> void rename(final K key, final K newKey, RedisOperations<K, ?> operations) {
        operations.execute(new SessionCallback<Object>(){

            @Override
            public Object execute(RedisOperations operations) throws DataAccessException {
                do {
                    operations.watch(key);
                    if (operations.hasKey(key).booleanValue()) {
                        operations.multi();
                        operations.rename(key, newKey);
                        continue;
                    }
                    operations.multi();
                } while (operations.exec() == null);
                return null;
            }
        });
    }

    static <K> Boolean renameIfAbsent(final K key, final K newKey, RedisOperations<K, ?> operations) {
        return operations.execute(new SessionCallback<Boolean>(){

            @Override
            public Boolean execute(RedisOperations operations) throws DataAccessException {
                boolean result;
                List<Object> exec = null;
                do {
                    operations.watch(key);
                    if (operations.hasKey(key).booleanValue()) {
                        operations.multi();
                        operations.renameIfAbsent(key, newKey);
                        continue;
                    }
                    operations.watch(newKey);
                    operations.multi();
                    operations.hasKey(newKey);
                    operations.hasKey(newKey);
                } while ((exec = operations.exec()) == null);
                boolean bl = result = (Long)exec.get(0) == 1L;
                if (exec.size() > 1) {
                    result = !result;
                }
                return result;
            }
        });
    }
}

