/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import org.jspecify.annotations.Nullable;
import org.springframework.data.r2dbc.core.R2dbcEntityTemplate;
import org.springframework.data.r2dbc.core.ReactiveInsertOperation;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

record ReactiveInsertOperationSupport(R2dbcEntityTemplate template) implements ReactiveInsertOperation
{
    @Override
    public <T> ReactiveInsertOperation.ReactiveInsert<T> insert(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveInsertSupport<T>(this.template, domainType, null);
    }

    static class ReactiveInsertSupport<T>
    implements ReactiveInsertOperation.ReactiveInsert<T> {
        private final R2dbcEntityTemplate template;
        private final Class<T> domainType;
        private final @Nullable SqlIdentifier tableName;

        ReactiveInsertSupport(R2dbcEntityTemplate template, Class<T> domainType, @Nullable SqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.tableName = tableName;
        }

        @Override
        public ReactiveInsertOperation.TerminatingInsert<T> into(SqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveInsertSupport<T>(this.template, this.domainType, tableName);
        }

        @Override
        public Mono<T> using(T object) {
            Assert.notNull(object, (String)"Object to insert must not be null");
            return this.template.doInsert(object, this.getTableName());
        }

        private SqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

