/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.R2dbcEntityTemplate;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.repository.query.PartTreeR2dbcQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.r2dbc.repository.query.StringBasedR2dbcQuery;
import org.springframework.data.r2dbc.repository.support.SimpleR2dbcRepository;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.relational.repository.support.MappingRelationalEntityInformation;
import org.springframework.data.relational.repository.support.RelationalQueryLookupStrategy;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.CachingValueExpressionDelegate;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.util.Assert;

public class R2dbcRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private final DatabaseClient databaseClient;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
    private final R2dbcConverter converter;
    private final R2dbcEntityOperations operations;

    public R2dbcRepositoryFactory(DatabaseClient databaseClient, ReactiveDataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)databaseClient, (String)"DatabaseClient must not be null");
        Assert.notNull((Object)dataAccessStrategy, (String)"ReactiveDataAccessStrategy must not be null");
        this.databaseClient = databaseClient;
        this.dataAccessStrategy = dataAccessStrategy;
        this.converter = dataAccessStrategy.getConverter();
        this.mappingContext = this.converter.getMappingContext();
        this.operations = new R2dbcEntityTemplate(this.databaseClient, this.dataAccessStrategy);
    }

    public R2dbcRepositoryFactory(R2dbcEntityOperations operations) {
        Assert.notNull((Object)operations, (String)"R2dbcEntityOperations must not be null");
        this.databaseClient = operations.getDatabaseClient();
        this.dataAccessStrategy = operations.getDataAccessStrategy();
        this.converter = this.dataAccessStrategy.getConverter();
        this.mappingContext = this.converter.getMappingContext();
        this.operations = operations;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleR2dbcRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        RelationalEntityInformation<?, ?> entityInformation = this.getEntityInformation((RepositoryMetadata)information);
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations, this.converter});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new R2dbcQueryLookupStrategy(this.operations, (ValueExpressionDelegate)new CachingValueExpressionDelegate(valueExpressionDelegate), this.converter, this.dataAccessStrategy));
    }

    public RelationalEntityInformation<?, ?> getEntityInformation(RepositoryMetadata metadata) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(metadata.getDomainType());
        return new MappingRelationalEntityInformation(entity);
    }

    private static class R2dbcQueryLookupStrategy
    extends RelationalQueryLookupStrategy {
        private final R2dbcEntityOperations entityOperations;
        private final R2dbcConverter converter;
        private final ValueExpressionDelegate delegate;
        private final ReactiveDataAccessStrategy dataAccessStrategy;

        R2dbcQueryLookupStrategy(R2dbcEntityOperations entityOperations, ValueExpressionDelegate delegate, R2dbcConverter converter, ReactiveDataAccessStrategy dataAccessStrategy) {
            super(converter.getMappingContext(), dataAccessStrategy.getDialect());
            this.delegate = delegate;
            this.entityOperations = entityOperations;
            this.converter = converter;
            this.dataAccessStrategy = dataAccessStrategy;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            R2dbcQueryMethod queryMethod = new R2dbcQueryMethod(method, metadata, factory, this.getMappingContext());
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName) || queryMethod.hasAnnotatedQuery()) {
                String query = namedQueries.hasQuery(namedQueryName) ? namedQueries.getQuery(namedQueryName) : queryMethod.getRequiredAnnotatedQuery();
                query = this.evaluateTableExpressions(metadata, query);
                return new StringBasedR2dbcQuery(query, queryMethod, this.entityOperations, this.converter, this.dataAccessStrategy, this.delegate);
            }
            return new PartTreeR2dbcQuery(queryMethod, this.entityOperations, this.converter, this.dataAccessStrategy);
        }
    }
}

