/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.ReadableMetadata;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.convert.RowMetadataUtils;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.r2dbc.support.ArrayUtils;
import org.springframework.data.relational.core.conversion.MappingRelationalConverter;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MappingR2dbcConverter
extends MappingRelationalConverter
implements R2dbcConverter {
    public MappingR2dbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context) {
        super((RelationalMappingContext)context, (CustomConversions)new R2dbcCustomConversions(R2dbcCustomConversions.STORE_CONVERSIONS, Collections.emptyList()));
    }

    public MappingR2dbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, CustomConversions conversions) {
        super((RelationalMappingContext)context, conversions);
    }

    public <R> R read(Class<R> type, Row row) {
        return this.read(type, row, null);
    }

    @Override
    public <R> R read(Class<R> type, Row row, @Nullable RowMetadata metadata) {
        TypeInformation typeInfo = TypeInformation.of(type);
        Class rawType = typeInfo.getType();
        if (Row.class.isAssignableFrom(rawType)) {
            return type.cast(row);
        }
        if (this.getConversions().hasCustomReadTarget(Row.class, rawType) && this.getConversionService().canConvert(Row.class, rawType)) {
            return (R)this.getConversionService().convert((Object)row, rawType);
        }
        RowDocument document = this.toRowDocument(type, (Readable)row, metadata != null ? metadata.getColumnMetadatas() : null);
        return (R)this.read(type, document);
    }

    @Override
    public RowDocument toRowDocument(Class<?> type, Readable row, @Nullable Iterable<? extends ReadableMetadata> metadata) {
        RowDocument document = new RowDocument();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(type);
        if (persistentEntity != null) {
            MappingR2dbcConverter.captureRowValues(row, metadata, document, persistentEntity);
        }
        if (metadata != null) {
            for (ReadableMetadata readableMetadata : metadata) {
                if (document.containsKey((Object)readableMetadata.getName())) continue;
                document.put(readableMetadata.getName(), row.get(readableMetadata.getName()));
            }
        }
        return document;
    }

    private static void captureRowValues(Readable row, @Nullable Iterable<? extends ReadableMetadata> metadata, RowDocument document, RelationalPersistentEntity<?> persistentEntity) {
        for (RelationalPersistentProperty property : persistentEntity) {
            String identifier = property.getColumnName().getReference();
            if (property.isEntity() || metadata != null && !RowMetadataUtils.containsColumn(metadata, identifier)) continue;
            Class propertyType = property.getType();
            Object value = propertyType.equals(Clob.class) ? row.get(identifier, Clob.class) : (propertyType.equals(Blob.class) ? row.get(identifier, Blob.class) : row.get(identifier));
            document.put(identifier, value);
        }
    }

    public void write(Object source, OutboundRow sink) {
        Class userClass = ClassUtils.getUserClass((Object)source);
        Optional customTarget = this.getConversions().getCustomWriteTarget(userClass, OutboundRow.class);
        if (customTarget.isPresent()) {
            OutboundRow result = (OutboundRow)this.getConversionService().convert(source, OutboundRow.class);
            sink.putAll(result);
            return;
        }
        this.writeInternal(source, sink, userClass);
    }

    private void writeInternal(Object source, OutboundRow sink, Class<?> userClass) {
        RelationalPersistentEntity<?> entity = this.getRequiredPersistentEntity(userClass);
        PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(source);
        this.writeProperties(sink, entity, propertyAccessor);
    }

    private void writeProperties(OutboundRow sink, RelationalPersistentEntity<?> entity, @Nullable PersistentPropertyAccessor<?> accessor) {
        for (RelationalPersistentProperty property : entity) {
            Object value;
            if (!property.isWritable()) continue;
            if (accessor == null) {
                value = null;
            } else if (property.isIdProperty()) {
                IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(accessor.getBean());
                value = identifierAccessor.getIdentifier();
            } else {
                value = accessor.getProperty((PersistentProperty)property);
            }
            if (property.isEmbedded()) {
                RelationalPersistentEntity embeddedEntity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity((PersistentProperty)property);
                PersistentPropertyAccessor embeddedAccessor = null;
                if (value != null) {
                    embeddedAccessor = embeddedEntity.getPropertyAccessor(value);
                }
                this.writeProperties(sink, embeddedEntity, embeddedAccessor);
                continue;
            }
            if (value == null) {
                this.writeNullInternal(sink, property);
                continue;
            }
            if (this.getConversions().isSimpleType(value.getClass())) {
                this.writeSimpleInternal(sink, value, property);
                continue;
            }
            this.writePropertyInternal(sink, value, property);
        }
    }

    private void writeSimpleInternal(OutboundRow sink, Object value, RelationalPersistentProperty property) {
        Object result = this.getPotentiallyConvertedSimpleWrite(value);
        sink.put(property.getColumnName(), Parameter.fromOrEmpty((Object)result, this.getPotentiallyConvertedSimpleNullType(property.getType())));
    }

    private void writePropertyInternal(OutboundRow sink, Object value, RelationalPersistentProperty property) {
        TypeInformation valueType = TypeInformation.of(value.getClass());
        if (valueType.isCollectionLike()) {
            if (valueType.getActualType() != null && valueType.getRequiredActualType().isCollectionLike()) {
                this.writeSimpleInternal(sink, value, property);
                return;
            }
            List<Object> collectionInternal = this.createCollection(MappingR2dbcConverter.asCollection(value), property);
            sink.put(property.getColumnName(), Parameter.from(collectionInternal));
            return;
        }
        throw new InvalidDataAccessApiUsageException("Nested entities are not supported");
    }

    protected List<Object> createCollection(Collection<?> collection, RelationalPersistentProperty property) {
        return this.writeCollectionInternal(collection, property.getTypeInformation(), new ArrayList());
    }

    private List<Object> writeCollectionInternal(Collection<?> source, @Nullable TypeInformation<?> type, Collection<?> sink) {
        List<Object> collection;
        TypeInformation componentType = null;
        List<Object> list = collection = sink instanceof List ? (List<Object>)sink : new ArrayList(sink);
        if (type != null) {
            componentType = type.getComponentType();
        }
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.getConversions().isSimpleType(elementType)) {
                collection.add(this.getPotentiallyConvertedSimpleWrite(element, componentType != null ? componentType.getType() : Object.class));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                collection.add(this.writeCollectionInternal(MappingR2dbcConverter.asCollection(element), componentType, new ArrayList()));
                continue;
            }
            throw new InvalidDataAccessApiUsageException("Nested entities are not supported");
        }
        return collection;
    }

    private void writeNullInternal(OutboundRow sink, RelationalPersistentProperty property) {
        sink.put(property.getColumnName(), Parameter.empty(this.getPotentiallyConvertedSimpleNullType(property.getType())));
    }

    private Class<?> getPotentiallyConvertedSimpleNullType(Class<?> type) {
        Optional customTarget = this.getConversions().getCustomWriteTarget(type);
        if (customTarget.isPresent()) {
            return (Class)customTarget.get();
        }
        if (type.isEnum()) {
            return String.class;
        }
        return type;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(@Nullable Object value) {
        return this.getPotentiallyConvertedSimpleWrite(value, Object.class);
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(@Nullable Object value, Class<?> typeHint) {
        Optional customTarget;
        if (value == null) {
            return null;
        }
        if (Object.class != typeHint && this.getConversionService().canConvert(value.getClass(), typeHint)) {
            value = this.getConversionService().convert(value, typeHint);
        }
        if ((customTarget = this.getConversions().getCustomWriteTarget(value.getClass())).isPresent()) {
            return this.getConversionService().convert(value, (Class)customTarget.get());
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    @Override
    public Object getArrayValue(ArrayColumns arrayColumns, RelationalPersistentProperty property, Object value) {
        Class<?> actualType = null;
        if (value instanceof Collection) {
            actualType = CollectionUtils.findCommonElementType((Collection)((Collection)value));
        } else if (value.getClass().isArray()) {
            actualType = value.getClass().getComponentType();
        }
        if (actualType == null) {
            actualType = property.getActualType();
        }
        actualType = this.getTargetType(actualType);
        Class targetType = arrayColumns.getArrayType(actualType);
        if (!property.isArray() || !targetType.isAssignableFrom(value.getClass())) {
            int depth = value.getClass().isArray() ? ArrayUtils.getDimensionDepth(value.getClass()) : 1;
            Class<?> targetArrayType = ArrayUtils.getArrayClass(targetType, depth);
            return this.getConversionService().convert(value, targetArrayType);
        }
        return value;
    }

    @Override
    public Class<?> getTargetType(Class<?> valueType) {
        Optional writeTarget = this.getConversions().getCustomWriteTarget(valueType);
        return writeTarget.orElseGet(() -> Enum.class.isAssignableFrom(valueType) ? String.class : valueType);
    }

    @Override
    public boolean isSimpleType(Class<?> type) {
        return this.getConversions().isSimpleType(type);
    }

    @Override
    public <T> BiFunction<Row, RowMetadata, T> populateIdIfNecessary(T object) {
        Assert.notNull(object, (String)"Entity object must not be null");
        Class userClass = ClassUtils.getUserClass(object);
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(userClass);
        if (!entity.hasIdProperty()) {
            return (row, rowMetadata) -> object;
        }
        return (row, metadata) -> {
            if (metadata == null) {
                metadata = row.getMetadata();
            }
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(object);
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entity.getRequiredIdProperty();
            boolean idPropertyUpdateNeeded = false;
            Object id = propertyAccessor.getProperty((PersistentProperty)idProperty);
            if (idProperty.getType().isPrimitive()) {
                Number number;
                idPropertyUpdateNeeded = id instanceof Number && (number = (Number)id).longValue() == 0L;
            } else {
                boolean bl = idPropertyUpdateNeeded = id == null;
            }
            if (idPropertyUpdateNeeded) {
                return this.potentiallySetId((Row)row, (RowMetadata)metadata, (PersistentPropertyAccessor<?>)propertyAccessor, idProperty) ? propertyAccessor.getBean() : object;
            }
            return object;
        };
    }

    private boolean potentiallySetId(Row row, RowMetadata metadata, PersistentPropertyAccessor<?> propertyAccessor, RelationalPersistentProperty idProperty) {
        String idColumnName = idProperty.getColumnName().getReference();
        Object generatedIdValue = this.extractGeneratedIdentifier(row, metadata, idColumnName);
        if (generatedIdValue == null) {
            return false;
        }
        ConversionService conversionService = this.getConversionService();
        propertyAccessor.setProperty((PersistentProperty)idProperty, conversionService.convert(generatedIdValue, idProperty.getType()));
        return true;
    }

    @Nullable
    private Object extractGeneratedIdentifier(Row row, RowMetadata metadata, String idColumnName) {
        if (RowMetadataUtils.containsColumn(metadata, idColumnName)) {
            return row.get(idColumnName);
        }
        Iterable<? extends ColumnMetadata> columns = RowMetadataUtils.getColumnMetadata(metadata);
        Iterator<? extends ColumnMetadata> it = columns.iterator();
        if (it.hasNext()) {
            ColumnMetadata column = it.next();
            return row.get(column.getName());
        }
        return null;
    }

    private <R> RelationalPersistentEntity<R> getRequiredPersistentEntity(Class<R> type) {
        return (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(type);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }
}

