/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.Map;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.repository.query.ValueExpressionQueryRewriter;

class ExpressionQuery {
    private static final String SYNTHETIC_PARAMETER_TEMPLATE = "__synthetic_%d__";
    private final String query;
    private final Map<String, ValueExpression> parameterMap;

    private ExpressionQuery(String query, Map<String, ValueExpression> parameterMap) {
        this.query = query;
        this.parameterMap = parameterMap;
    }

    public static ExpressionQuery create(ValueExpressionParser parser, String query) {
        ValueExpressionQueryRewriter rewriter = ValueExpressionQueryRewriter.of((ValueExpressionParser)parser, (counter, expression) -> String.format(SYNTHETIC_PARAMETER_TEMPLATE, counter), String::concat);
        ValueExpressionQueryRewriter.ParsedQuery parsed = rewriter.parse(query);
        return new ExpressionQuery(parsed.getQueryString(), parsed.getParameterMap());
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, ValueExpression> getBindings() {
        return this.parameterMap;
    }

    public String toString() {
        return this.query;
    }
}

