/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import io.r2dbc.postgresql.codec.Box;
import io.r2dbc.postgresql.codec.Json;
import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.codec.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.geo.Circle;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.dialect.SimpleTypeArrayColumns;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.dialect.ObjectArrayColumns;
import org.springframework.data.util.Lazy;
import org.springframework.lang.NonNull;
import org.springframework.r2dbc.core.binding.BindMarkersFactory;
import org.springframework.util.ClassUtils;

public class PostgresDialect
extends org.springframework.data.relational.core.dialect.PostgresDialect
implements R2dbcDialect {
    private static final Set<Class<?>> SIMPLE_TYPES;
    private static final boolean JSON_PRESENT;
    private static final boolean GEO_TYPES_PRESENT;
    public static final PostgresDialect INSTANCE;
    private static final BindMarkersFactory INDEXED;
    private final Lazy<ArrayColumns> arrayColumns = Lazy.of(() -> new SimpleTypeArrayColumns((ArrayColumns)ObjectArrayColumns.INSTANCE, this.getSimpleTypeHolder()));

    @Override
    public BindMarkersFactory getBindMarkersFactory() {
        return INDEXED;
    }

    @Override
    public Collection<? extends Class<?>> getSimpleTypes() {
        return SIMPLE_TYPES;
    }

    public ArrayColumns getArraySupport() {
        return (ArrayColumns)this.arrayColumns.get();
    }

    @Override
    public Collection<Object> getConverters() {
        if (!GEO_TYPES_PRESENT && !JSON_PRESENT) {
            return Collections.emptyList();
        }
        ArrayList<Object> converters = new ArrayList<Object>();
        if (GEO_TYPES_PRESENT) {
            converters.addAll(Arrays.asList(new Enum[]{FromPostgresPointConverter.INSTANCE, ToPostgresPointConverter.INSTANCE, FromPostgresCircleConverter.INSTANCE, ToPostgresCircleConverter.INSTANCE, FromPostgresBoxConverter.INSTANCE, ToPostgresBoxConverter.INSTANCE, FromPostgresPolygonConverter.INSTANCE, ToPostgresPolygonConverter.INSTANCE}));
        }
        if (JSON_PRESENT) {
            converters.addAll(Arrays.asList(new Enum[]{JsonToByteArrayConverter.INSTANCE, JsonToStringConverter.INSTANCE}));
        }
        return converters;
    }

    private static void ifClassPresent(String className, Consumer<Class<?>> action) {
        if (ClassUtils.isPresent((String)className, (ClassLoader)PostgresDialect.class.getClassLoader())) {
            action.accept(ClassUtils.resolveClassName((String)className, (ClassLoader)PostgresDialect.class.getClassLoader()));
        }
    }

    static {
        JSON_PRESENT = ClassUtils.isPresent((String)"io.r2dbc.postgresql.codec.Json", (ClassLoader)PostgresDialect.class.getClassLoader());
        GEO_TYPES_PRESENT = ClassUtils.isPresent((String)"io.r2dbc.postgresql.codec.Polygon", (ClassLoader)PostgresDialect.class.getClassLoader());
        HashSet simpleTypes = new HashSet(org.springframework.data.relational.core.dialect.PostgresDialect.INSTANCE.simpleTypes());
        Stream.of("io.r2dbc.postgresql.codec.Box", "io.r2dbc.postgresql.codec.Circle", "io.r2dbc.postgresql.codec.Line", "io.r2dbc.postgresql.codec.Lseg", "io.r2dbc.postgresql.codec.Point", "io.r2dbc.postgresql.codec.Path", "io.r2dbc.postgresql.codec.Polygon").forEach(s -> PostgresDialect.ifClassPresent(s, simpleTypes::add));
        PostgresDialect.ifClassPresent("io.r2dbc.postgresql.codec.Json", simpleTypes::add);
        PostgresDialect.ifClassPresent("io.r2dbc.postgresql.codec.Interval", simpleTypes::add);
        SIMPLE_TYPES = simpleTypes;
        INSTANCE = new PostgresDialect();
        INDEXED = BindMarkersFactory.indexed((String)"$", (int)1);
    }

    @ReadingConverter
    private static enum FromPostgresPointConverter implements Converter<Point, org.springframework.data.geo.Point>
    {
        INSTANCE;


        @NonNull
        public org.springframework.data.geo.Point convert(Point source) {
            return new org.springframework.data.geo.Point(source.getX(), source.getY());
        }
    }

    @WritingConverter
    private static enum ToPostgresPointConverter implements Converter<org.springframework.data.geo.Point, Point>
    {
        INSTANCE;


        @NonNull
        public Point convert(org.springframework.data.geo.Point source) {
            return Point.of((double)source.getX(), (double)source.getY());
        }
    }

    @ReadingConverter
    private static enum FromPostgresCircleConverter implements Converter<io.r2dbc.postgresql.codec.Circle, Circle>
    {
        INSTANCE;


        public Circle convert(io.r2dbc.postgresql.codec.Circle source) {
            return new Circle(source.getCenter().getX(), source.getCenter().getY(), source.getRadius());
        }
    }

    @WritingConverter
    private static enum ToPostgresCircleConverter implements Converter<Circle, io.r2dbc.postgresql.codec.Circle>
    {
        INSTANCE;


        public io.r2dbc.postgresql.codec.Circle convert(Circle source) {
            return io.r2dbc.postgresql.codec.Circle.of((double)source.getCenter().getX(), (double)source.getCenter().getY(), (double)source.getRadius().getValue());
        }
    }

    @ReadingConverter
    private static enum FromPostgresBoxConverter implements Converter<Box, org.springframework.data.geo.Box>
    {
        INSTANCE;


        public org.springframework.data.geo.Box convert(Box source) {
            return new org.springframework.data.geo.Box(FromPostgresPointConverter.INSTANCE.convert(source.getA()), FromPostgresPointConverter.INSTANCE.convert(source.getB()));
        }
    }

    @WritingConverter
    private static enum ToPostgresBoxConverter implements Converter<org.springframework.data.geo.Box, Box>
    {
        INSTANCE;


        public Box convert(org.springframework.data.geo.Box source) {
            return Box.of((Point)ToPostgresPointConverter.INSTANCE.convert(source.getFirst()), (Point)ToPostgresPointConverter.INSTANCE.convert(source.getSecond()));
        }
    }

    @ReadingConverter
    private static enum FromPostgresPolygonConverter implements Converter<Polygon, org.springframework.data.geo.Polygon>
    {
        INSTANCE;


        public org.springframework.data.geo.Polygon convert(Polygon source) {
            List sourcePoints = source.getPoints();
            ArrayList<org.springframework.data.geo.Point> targetPoints = new ArrayList<org.springframework.data.geo.Point>(sourcePoints.size());
            for (Point sourcePoint : sourcePoints) {
                targetPoints.add(FromPostgresPointConverter.INSTANCE.convert(sourcePoint));
            }
            return new org.springframework.data.geo.Polygon(targetPoints);
        }
    }

    @WritingConverter
    private static enum ToPostgresPolygonConverter implements Converter<org.springframework.data.geo.Polygon, Polygon>
    {
        INSTANCE;


        public Polygon convert(org.springframework.data.geo.Polygon source) {
            List sourcePoints = source.getPoints();
            ArrayList<Point> targetPoints = new ArrayList<Point>(sourcePoints.size());
            for (org.springframework.data.geo.Point sourcePoint : sourcePoints) {
                targetPoints.add(ToPostgresPointConverter.INSTANCE.convert(sourcePoint));
            }
            return Polygon.of(targetPoints);
        }
    }

    @ReadingConverter
    private static enum JsonToByteArrayConverter implements Converter<Json, byte[]>
    {
        INSTANCE;


        @NonNull
        public byte[] convert(Json source) {
            return source.asArray();
        }
    }

    @ReadingConverter
    private static enum JsonToStringConverter implements Converter<Json, String>
    {
        INSTANCE;


        @NonNull
        public String convert(Json source) {
            return source.asString();
        }
    }
}

