/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.r2dbc.core.binding.BindMarkersFactory;

public class MySqlDialect
extends org.springframework.data.relational.core.dialect.MySqlDialect
implements R2dbcDialect {
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(UUID.class, URL.class, URI.class, InetAddress.class));
    public static final MySqlDialect INSTANCE = new MySqlDialect();
    private static final BindMarkersFactory ANONYMOUS = BindMarkersFactory.anonymous((String)"?");
    private static final List<Object> CONVERTERS = Arrays.asList(new Object[]{ByteToBooleanConverter.INSTANCE, BooleanToByteConverter.INSTANCE});

    @Override
    public BindMarkersFactory getBindMarkersFactory() {
        return ANONYMOUS;
    }

    @Override
    public Collection<? extends Class<?>> getSimpleTypes() {
        return SIMPLE_TYPES;
    }

    @Override
    public Collection<Object> getConverters() {
        return CONVERTERS;
    }

    @Override
    public String renderForGeneratedValues(SqlIdentifier identifier) {
        return identifier.getReference(this.getIdentifierProcessing());
    }

    @ReadingConverter
    public static enum ByteToBooleanConverter implements Converter<Byte, Boolean>
    {
        INSTANCE;


        public Boolean convert(Byte s) {
            if (s == null) {
                return null;
            }
            return s != 0;
        }
    }

    @WritingConverter
    public static enum BooleanToByteConverter implements Converter<Boolean, Byte>
    {
        INSTANCE;


        public Byte convert(Boolean s) {
            return (byte)(s != false ? 1 : 0);
        }
    }
}

