/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.ArrayList;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.repository.query.AbstractR2dbcQuery;
import org.springframework.data.r2dbc.repository.query.BindableQuery;
import org.springframework.data.r2dbc.repository.query.DefaultR2dbcSpELExpressionEvaluator;
import org.springframework.data.r2dbc.repository.query.ExpressionEvaluatingParameterBinder;
import org.springframework.data.r2dbc.repository.query.ExpressionQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.r2dbc.repository.query.R2dbcSpELExpressionEvaluator;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class StringBasedR2dbcQuery
extends AbstractR2dbcQuery {
    private final ExpressionQuery expressionQuery;
    private final ExpressionEvaluatingParameterBinder binder;
    private final ExpressionParser expressionParser;
    private final ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider;
    private final ExpressionDependencies expressionDependencies;

    public StringBasedR2dbcQuery(R2dbcQueryMethod queryMethod, DatabaseClient databaseClient, R2dbcConverter converter, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredAnnotatedQuery(), queryMethod, databaseClient, converter, expressionParser, evaluationContextProvider);
    }

    public StringBasedR2dbcQuery(String query, R2dbcQueryMethod method, DatabaseClient databaseClient, R2dbcConverter converter, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, databaseClient, converter);
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        Assert.hasText((String)query, (String)"Query must not be empty");
        this.expressionQuery = ExpressionQuery.create(query);
        this.binder = new ExpressionEvaluatingParameterBinder(this.expressionQuery);
        this.expressionDependencies = this.createExpressionDependencies();
    }

    private ExpressionDependencies createExpressionDependencies() {
        if (this.expressionQuery.getBindings().isEmpty()) {
            return ExpressionDependencies.none();
        }
        ArrayList<ExpressionDependencies> dependencies = new ArrayList<ExpressionDependencies>();
        for (ExpressionQuery.ParameterBinding binding : this.expressionQuery.getBindings()) {
            dependencies.add(ExpressionDependencies.discover((Expression)this.expressionParser.parseExpression(binding.getExpression())));
        }
        return ExpressionDependencies.merged(dependencies);
    }

    @Override
    protected boolean isModifyingQuery() {
        return this.getQueryMethod().isModifyingQuery();
    }

    @Override
    protected Mono<BindableQuery> createQuery(final RelationalParameterAccessor accessor) {
        return this.getSpelEvaluator(accessor).map(evaluator -> new BindableQuery((R2dbcSpELExpressionEvaluator)evaluator){
            final /* synthetic */ R2dbcSpELExpressionEvaluator val$evaluator;
            {
                this.val$evaluator = r2dbcSpELExpressionEvaluator;
            }

            @Override
            public DatabaseClient.GenericExecuteSpec bind(DatabaseClient.GenericExecuteSpec bindSpec) {
                return StringBasedR2dbcQuery.this.binder.bind(bindSpec, accessor, this.val$evaluator);
            }

            @Override
            public String get() {
                return StringBasedR2dbcQuery.this.expressionQuery.getQuery();
            }
        });
    }

    private Mono<R2dbcSpELExpressionEvaluator> getSpelEvaluator(RelationalParameterAccessor accessor) {
        return this.evaluationContextProvider.getEvaluationContextLater((Parameters)this.getQueryMethod().getParameters(), accessor.getValues(), this.expressionDependencies).map(context -> new DefaultR2dbcSpELExpressionEvaluator(this.expressionParser, (EvaluationContext)context)).defaultIfEmpty((Object)DefaultR2dbcSpELExpressionEvaluator.unsupported());
    }
}

