/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.core.PreparedOperation;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.r2dbc.dialect.BindTarget;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.query.BoundAssignments;
import org.springframework.data.r2dbc.query.BoundCondition;
import org.springframework.data.r2dbc.query.UpdateMapper;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.AssignValue;
import org.springframework.data.relational.core.sql.Assignment;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.DeleteBuilder;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.InsertBuilder;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.StatementBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.data.relational.core.sql.UpdateBuilder;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.binding.BindMarkers;
import org.springframework.r2dbc.core.binding.Bindings;
import org.springframework.util.Assert;

class DefaultStatementMapper
implements StatementMapper {
    private final R2dbcDialect dialect;
    private final RenderContext renderContext;
    private final UpdateMapper updateMapper;
    private final MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;

    DefaultStatementMapper(R2dbcDialect dialect, RenderContext renderContext, UpdateMapper updateMapper, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        this.dialect = dialect;
        this.renderContext = renderContext;
        this.updateMapper = updateMapper;
        this.mappingContext = mappingContext;
    }

    @Override
    public <T> StatementMapper.TypedStatementMapper<T> forType(Class<T> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return new DefaultTypedStatementMapper((RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type));
    }

    public PreparedOperation<?> getMappedObject(StatementMapper.SelectSpec selectSpec) {
        return this.getMappedObject(selectSpec, null);
    }

    private PreparedOperation<Select> getMappedObject(StatementMapper.SelectSpec selectSpec, @Nullable RelationalPersistentEntity<?> entity) {
        Table table = selectSpec.getTable();
        SelectBuilder.SelectAndFrom selectAndFrom = StatementBuilder.select(this.getSelectList(selectSpec, entity));
        if (selectSpec.isDistinct()) {
            selectAndFrom = selectAndFrom.distinct();
        }
        SelectBuilder.SelectFromAndJoin selectBuilder = selectAndFrom.from(table);
        BindMarkers bindMarkers = this.dialect.getBindMarkersFactory().create();
        Bindings bindings = Bindings.empty();
        CriteriaDefinition criteria = selectSpec.getCriteria();
        if (criteria != null && !criteria.isEmpty()) {
            BoundCondition mappedObject = this.updateMapper.getMappedObject(bindMarkers, criteria, table, entity);
            bindings = mappedObject.getBindings();
            selectBuilder.where(mappedObject.getCondition());
        }
        if (selectSpec.getSort().isSorted()) {
            List<OrderByField> sort = this.updateMapper.getMappedSort(table, selectSpec.getSort(), entity);
            selectBuilder.orderBy(sort);
        }
        if (selectSpec.getLimit() > 0) {
            selectBuilder.limit((long)selectSpec.getLimit());
        }
        if (selectSpec.getOffset() > 0L) {
            selectBuilder.offset(selectSpec.getOffset());
        }
        Select select = selectBuilder.build();
        return new DefaultPreparedOperation<Select>(select, this.renderContext, bindings);
    }

    protected List<Expression> getSelectList(StatementMapper.SelectSpec selectSpec, @Nullable RelationalPersistentEntity<?> entity) {
        if (entity == null) {
            return selectSpec.getSelectList();
        }
        List<Expression> selectList = selectSpec.getSelectList();
        ArrayList<Expression> mapped = new ArrayList<Expression>(selectList.size());
        for (Expression expression : selectList) {
            mapped.add(this.updateMapper.getMappedObject(expression, entity));
        }
        return mapped;
    }

    public PreparedOperation<Insert> getMappedObject(StatementMapper.InsertSpec insertSpec) {
        return this.getMappedObject(insertSpec, null);
    }

    private PreparedOperation<Insert> getMappedObject(StatementMapper.InsertSpec insertSpec, @Nullable RelationalPersistentEntity<?> entity) {
        BindMarkers bindMarkers = this.dialect.getBindMarkersFactory().create();
        Table table = Table.create((String)this.toSql(insertSpec.getTable()));
        BoundAssignments boundAssignments = this.updateMapper.getMappedObject(bindMarkers, insertSpec.getAssignments(), table, entity);
        Bindings bindings = boundAssignments.getBindings();
        InsertBuilder.InsertIntoColumnsAndValues insertBuilder = StatementBuilder.insert((Table)table);
        InsertBuilder.InsertValuesWithBuild withBuild = (InsertBuilder.InsertValuesWithBuild)insertBuilder;
        for (Assignment assignment : boundAssignments.getAssignments()) {
            if (!(assignment instanceof AssignValue)) continue;
            AssignValue assignValue = (AssignValue)assignment;
            insertBuilder.column(assignValue.getColumn());
            withBuild = insertBuilder.value(assignValue.getValue());
        }
        return new DefaultPreparedOperation<Insert>(withBuild.build(), this.renderContext, bindings);
    }

    public PreparedOperation<Update> getMappedObject(StatementMapper.UpdateSpec updateSpec) {
        return this.getMappedObject(updateSpec, null);
    }

    private PreparedOperation<Update> getMappedObject(StatementMapper.UpdateSpec updateSpec, @Nullable RelationalPersistentEntity<?> entity) {
        Update update;
        BindMarkers bindMarkers = this.dialect.getBindMarkersFactory().create();
        Table table = Table.create((String)this.toSql(updateSpec.getTable()));
        if (updateSpec.getUpdate() == null || updateSpec.getUpdate().getAssignments().isEmpty()) {
            throw new IllegalArgumentException("UPDATE contains no assignments");
        }
        BoundAssignments boundAssignments = this.updateMapper.getMappedObject(bindMarkers, updateSpec.getUpdate().getAssignments(), table, entity);
        Bindings bindings = boundAssignments.getBindings();
        UpdateBuilder.UpdateWhere updateBuilder = StatementBuilder.update((Table)table).set(boundAssignments.getAssignments());
        CriteriaDefinition criteria = updateSpec.getCriteria();
        if (criteria != null && !criteria.isEmpty()) {
            BoundCondition boundCondition = this.updateMapper.getMappedObject(bindMarkers, criteria, table, entity);
            bindings = bindings.and(boundCondition.getBindings());
            update = updateBuilder.where(boundCondition.getCondition()).build();
        } else {
            update = updateBuilder.build();
        }
        return new DefaultPreparedOperation<Update>(update, this.renderContext, bindings);
    }

    public PreparedOperation<Delete> getMappedObject(StatementMapper.DeleteSpec deleteSpec) {
        return this.getMappedObject(deleteSpec, null);
    }

    @Override
    public RenderContext getRenderContext() {
        return this.renderContext;
    }

    private PreparedOperation<Delete> getMappedObject(StatementMapper.DeleteSpec deleteSpec, @Nullable RelationalPersistentEntity<?> entity) {
        Delete delete;
        BindMarkers bindMarkers = this.dialect.getBindMarkersFactory().create();
        Table table = Table.create((String)this.toSql(deleteSpec.getTable()));
        DeleteBuilder.DeleteWhere deleteBuilder = StatementBuilder.delete((Table)table);
        Bindings bindings = Bindings.empty();
        CriteriaDefinition criteria = deleteSpec.getCriteria();
        if (criteria != null && !criteria.isEmpty()) {
            BoundCondition boundCondition = this.updateMapper.getMappedObject(bindMarkers, deleteSpec.getCriteria(), table, entity);
            bindings = boundCondition.getBindings();
            delete = deleteBuilder.where(boundCondition.getCondition()).build();
        } else {
            delete = deleteBuilder.build();
        }
        return new DefaultPreparedOperation<Delete>(delete, this.renderContext, bindings);
    }

    private String toSql(SqlIdentifier identifier) {
        Assert.notNull((Object)identifier, (String)"SqlIdentifier must not be null");
        return identifier.toSql(this.dialect.getIdentifierProcessing());
    }

    class DefaultTypedStatementMapper<T>
    implements StatementMapper.TypedStatementMapper<T> {
        final RelationalPersistentEntity<T> entity;

        DefaultTypedStatementMapper(RelationalPersistentEntity<T> entity) {
            this.entity = entity;
        }

        public <TC> StatementMapper.TypedStatementMapper<TC> forType(Class<TC> type) {
            return DefaultStatementMapper.this.forType(type);
        }

        public PreparedOperation<?> getMappedObject(StatementMapper.SelectSpec selectSpec) {
            return DefaultStatementMapper.this.getMappedObject(selectSpec, this.entity);
        }

        public PreparedOperation<?> getMappedObject(StatementMapper.InsertSpec insertSpec) {
            return DefaultStatementMapper.this.getMappedObject(insertSpec, this.entity);
        }

        public PreparedOperation<?> getMappedObject(StatementMapper.UpdateSpec updateSpec) {
            return DefaultStatementMapper.this.getMappedObject(updateSpec, this.entity);
        }

        public PreparedOperation<?> getMappedObject(StatementMapper.DeleteSpec deleteSpec) {
            return DefaultStatementMapper.this.getMappedObject(deleteSpec, this.entity);
        }

        @Override
        public RenderContext getRenderContext() {
            return DefaultStatementMapper.this.getRenderContext();
        }
    }

    static class DefaultPreparedOperation<T>
    implements PreparedOperation<T> {
        private final T source;
        private final RenderContext renderContext;
        private final Bindings bindings;

        DefaultPreparedOperation(T source, RenderContext renderContext, Bindings bindings) {
            this.source = source;
            this.renderContext = renderContext;
            this.bindings = bindings;
        }

        @Override
        public T getSource() {
            return this.source;
        }

        @Override
        public String toQuery() {
            SqlRenderer sqlRenderer = SqlRenderer.create((RenderContext)this.renderContext);
            if (this.source instanceof Select) {
                return sqlRenderer.render((Select)this.source);
            }
            if (this.source instanceof Insert) {
                return sqlRenderer.render((Insert)this.source);
            }
            if (this.source instanceof Update) {
                return sqlRenderer.render((Update)this.source);
            }
            if (this.source instanceof Delete) {
                return sqlRenderer.render((Delete)this.source);
            }
            throw new IllegalStateException("Cannot render " + this.getSource());
        }

        @Override
        public void bindTo(BindTarget to) {
            this.bindings.apply((org.springframework.r2dbc.core.binding.BindTarget)to);
        }

        public void bindTo(org.springframework.r2dbc.core.binding.BindTarget to) {
            this.bindings.apply(to);
        }
    }
}

