/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.beans.FeatureDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.DefaultDatabaseClient;
import org.springframework.data.r2dbc.core.PreparedOperation;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.ReactiveDeleteOperation;
import org.springframework.data.r2dbc.core.ReactiveDeleteOperationSupport;
import org.springframework.data.r2dbc.core.ReactiveInsertOperation;
import org.springframework.data.r2dbc.core.ReactiveInsertOperationSupport;
import org.springframework.data.r2dbc.core.ReactiveSelectOperation;
import org.springframework.data.r2dbc.core.ReactiveSelectOperationSupport;
import org.springframework.data.r2dbc.core.ReactiveUpdateOperation;
import org.springframework.data.r2dbc.core.ReactiveUpdateOperationSupport;
import org.springframework.data.r2dbc.core.RowsFetchSpec;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.query.Update;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.util.ProxyUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class R2dbcEntityTemplate
implements R2dbcEntityOperations,
BeanFactoryAware {
    private final DatabaseClient databaseClient;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
    private final SpelAwareProxyProjectionFactory projectionFactory;

    public R2dbcEntityTemplate(DatabaseClient databaseClient) {
        this(databaseClient, R2dbcEntityTemplate.getDataAccessStrategy(databaseClient));
    }

    public R2dbcEntityTemplate(DatabaseClient databaseClient, ReactiveDataAccessStrategy strategy) {
        Assert.notNull((Object)databaseClient, (String)"DatabaseClient must not be null");
        Assert.notNull((Object)strategy, (String)"ReactiveDataAccessStrategy must not be null");
        this.databaseClient = databaseClient;
        this.dataAccessStrategy = strategy;
        this.mappingContext = strategy.getConverter().getMappingContext();
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
    }

    @Override
    public DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    @Override
    public ReactiveDataAccessStrategy getDataAccessStrategy() {
        return this.dataAccessStrategy;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.projectionFactory.setBeanFactory(beanFactory);
    }

    @Override
    public <T> ReactiveSelectOperation.ReactiveSelect<T> select(Class<T> domainType) {
        return new ReactiveSelectOperationSupport(this).select(domainType);
    }

    @Override
    public <T> ReactiveInsertOperation.ReactiveInsert<T> insert(Class<T> domainType) {
        return new ReactiveInsertOperationSupport(this).insert(domainType);
    }

    @Override
    public ReactiveUpdateOperation.ReactiveUpdate update(Class<?> domainType) {
        return new ReactiveUpdateOperationSupport(this).update(domainType);
    }

    @Override
    public ReactiveDeleteOperation.ReactiveDelete delete(Class<?> domainType) {
        return new ReactiveDeleteOperationSupport(this).delete(domainType);
    }

    @Override
    public Mono<Long> count(Query query, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"entity class must not be null");
        return this.doCount(query, entityClass, this.getTableName(entityClass));
    }

    Mono<Long> doCount(Query query, Class<?> entityClass, SqlIdentifier tableName) {
        RelationalPersistentEntity<Class<?>> entity = this.getRequiredEntity((Object)entityClass);
        StatementMapper.TypedStatementMapper<?> statementMapper = this.dataAccessStrategy.getStatementMapper().forType(entityClass);
        StatementMapper.SelectSpec selectSpec = statementMapper.createSelect(tableName).doWithTable((table, spec) -> spec.withProjection(new Expression[]{Functions.count((Expression[])new Expression[]{table.column(((RelationalPersistentProperty)entity.getRequiredIdProperty()).getColumnName())})}));
        Optional criteria = query.getCriteria();
        if (criteria.isPresent()) {
            selectSpec = criteria.map(selectSpec::withCriteria).orElse(selectSpec);
        }
        PreparedOperation<?> operation = statementMapper.getMappedObject(selectSpec);
        return this.databaseClient.execute(operation).map((r, md) -> (Long)r.get(0, Long.class)).first().defaultIfEmpty((Object)0L);
    }

    @Override
    public Mono<Boolean> exists(Query query, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"entity class must not be null");
        return this.doExists(query, entityClass, this.getTableName(entityClass));
    }

    Mono<Boolean> doExists(Query query, Class<?> entityClass, SqlIdentifier tableName) {
        RelationalPersistentEntity<Class<?>> entity = this.getRequiredEntity((Object)entityClass);
        StatementMapper.TypedStatementMapper<?> statementMapper = this.dataAccessStrategy.getStatementMapper().forType(entityClass);
        SqlIdentifier columnName = entity.hasIdProperty() ? ((RelationalPersistentProperty)entity.getRequiredIdProperty()).getColumnName() : SqlIdentifier.unquoted((String)"*");
        StatementMapper.SelectSpec selectSpec = statementMapper.createSelect(tableName).withProjection(columnName).limit(1);
        Optional criteria = query.getCriteria();
        if (criteria.isPresent()) {
            selectSpec = criteria.map(selectSpec::withCriteria).orElse(selectSpec);
        }
        PreparedOperation<?> operation = statementMapper.getMappedObject(selectSpec);
        return this.databaseClient.execute(operation).map((r, md) -> r).first().hasElement();
    }

    @Override
    public <T> Flux<T> select(Query query, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"entity class must not be null");
        return this.doSelect(query, entityClass, this.getTableName(entityClass), entityClass).all();
    }

    <T> RowsFetchSpec<T> doSelect(Query query, Class<?> entityClass, SqlIdentifier tableName, Class<T> returnType) {
        Optional criteria;
        StatementMapper.TypedStatementMapper<?> statementMapper = this.dataAccessStrategy.getStatementMapper().forType(entityClass);
        StatementMapper.SelectSpec selectSpec = statementMapper.createSelect(tableName).doWithTable((table, spec) -> spec.withProjection(this.getSelectProjection((Table)table, query, returnType)));
        if (query.getLimit() > 0) {
            selectSpec = selectSpec.limit(query.getLimit());
        }
        if (query.getOffset() > 0L) {
            selectSpec = selectSpec.offset(query.getOffset());
        }
        if (query.isSorted()) {
            selectSpec = selectSpec.withSort(query.getSort());
        }
        if ((criteria = query.getCriteria()).isPresent()) {
            selectSpec = criteria.map(selectSpec::withCriteria).orElse(selectSpec);
        }
        PreparedOperation<?> operation = statementMapper.getMappedObject(selectSpec);
        BiFunction<Row, RowMetadata, Object> rowMapper = returnType.isInterface() ? this.dataAccessStrategy.getRowMapper(entityClass).andThen(o -> this.projectionFactory.createProjection(returnType, o)) : this.dataAccessStrategy.getRowMapper(returnType);
        return this.databaseClient.execute(operation).map(rowMapper);
    }

    @Override
    public <T> Mono<T> selectOne(Query query, Class<T> entityClass) throws DataAccessException {
        return this.doSelect(query.limit(2), entityClass, this.getTableName(entityClass), entityClass).one();
    }

    @Override
    public Mono<Integer> update(Query query, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"entity class must not be null");
        return this.doUpdate(query, update, entityClass, this.getTableName(entityClass));
    }

    Mono<Integer> doUpdate(Query query, Update update, Class<?> entityClass, SqlIdentifier tableName) {
        StatementMapper.TypedStatementMapper<?> statementMapper = this.dataAccessStrategy.getStatementMapper().forType(entityClass);
        StatementMapper.UpdateSpec selectSpec = statementMapper.createUpdate(tableName, update);
        Optional criteria = query.getCriteria();
        if (criteria.isPresent()) {
            selectSpec = criteria.map(selectSpec::withCriteria).orElse(selectSpec);
        }
        PreparedOperation<?> operation = statementMapper.getMappedObject(selectSpec);
        return this.databaseClient.execute(operation).fetch().rowsUpdated();
    }

    @Override
    public Mono<Integer> delete(Query query, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"entity class must not be null");
        return this.doDelete(query, entityClass, this.getTableName(entityClass));
    }

    Mono<Integer> doDelete(Query query, Class<?> entityClass, SqlIdentifier tableName) {
        StatementMapper.TypedStatementMapper<?> statementMapper = this.dataAccessStrategy.getStatementMapper().forType(entityClass);
        StatementMapper.DeleteSpec selectSpec = statementMapper.createDelete(tableName);
        Optional criteria = query.getCriteria();
        if (criteria.isPresent()) {
            selectSpec = criteria.map(selectSpec::withCriteria).orElse(selectSpec);
        }
        PreparedOperation<?> operation = statementMapper.getMappedObject(selectSpec);
        return this.databaseClient.execute(operation).fetch().rowsUpdated().defaultIfEmpty((Object)0);
    }

    @Override
    public <T> Mono<T> insert(T entity) throws DataAccessException {
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.doInsert(entity, this.getRequiredEntity(entity).getTableName());
    }

    <T> Mono<T> doInsert(T entity, SqlIdentifier tableName) {
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredEntity(entity);
        T entityToInsert = this.setVersionIfNecessary(persistentEntity, entity);
        return this.databaseClient.insert().into(persistentEntity.getType()).table(tableName).using(entityToInsert).map(this.dataAccessStrategy.getConverter().populateIdIfNecessary(entityToInsert)).all().last(entityToInsert);
    }

    private <T> T setVersionIfNecessary(RelationalPersistentEntity<T> persistentEntity, T entity) {
        RelationalPersistentProperty versionProperty = (RelationalPersistentProperty)persistentEntity.getVersionProperty();
        if (versionProperty == null) {
            return entity;
        }
        Class versionPropertyType = versionProperty.getType();
        Long version = versionPropertyType.isPrimitive() ? 1L : 0L;
        ConversionService conversionService = this.dataAccessStrategy.getConverter().getConversionService();
        PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(entity);
        propertyAccessor.setProperty((PersistentProperty)versionProperty, conversionService.convert((Object)version, versionPropertyType));
        return (T)propertyAccessor.getBean();
    }

    @Override
    public <T> Mono<T> update(T entity) throws DataAccessException {
        DatabaseClient.UpdateSpec matching;
        Object entityToUpdate;
        Assert.notNull(entity, (String)"Entity must not be null");
        RelationalPersistentEntity persistentEntity = this.getRequiredEntity(entity);
        DatabaseClient.TypedUpdateSpec<T> updateMatchingSpec = this.databaseClient.update().table(persistentEntity.getType()).table(persistentEntity.getTableName());
        if (persistentEntity.hasVersionProperty()) {
            Criteria criteria = this.createMatchingVersionCriteria(entity, persistentEntity);
            entityToUpdate = this.incrementVersion(persistentEntity, entity);
            matching = updateMatchingSpec.using(entityToUpdate).matching((CriteriaDefinition)criteria);
        } else {
            entityToUpdate = entity;
            matching = updateMatchingSpec.using(entity);
        }
        return matching.fetch().rowsUpdated().flatMap(rowsUpdated -> rowsUpdated == 0 ? this.handleMissingUpdate(entityToUpdate, persistentEntity) : Mono.just((Object)entityToUpdate));
    }

    private <T> Mono<? extends T> handleMissingUpdate(T entity, RelationalPersistentEntity<T> persistentEntity) {
        return Mono.error((Throwable)(persistentEntity.hasVersionProperty() ? new OptimisticLockingFailureException(this.formatOptimisticLockingExceptionMessage(entity, persistentEntity)) : new TransientDataAccessResourceException(this.formatTransientEntityExceptionMessage(entity, persistentEntity))));
    }

    private <T> String formatOptimisticLockingExceptionMessage(T entity, RelationalPersistentEntity<T> persistentEntity) {
        return String.format("Failed to update table [%s]. Version does not match for row with Id [%s].", persistentEntity.getTableName(), persistentEntity.getIdentifierAccessor(entity).getIdentifier());
    }

    private <T> String formatTransientEntityExceptionMessage(T entity, RelationalPersistentEntity<T> persistentEntity) {
        return String.format("Failed to update table [%s]. Row with Id [%s] does not exist.", persistentEntity.getTableName(), persistentEntity.getIdentifierAccessor(entity).getIdentifier());
    }

    private <T> T incrementVersion(RelationalPersistentEntity<T> persistentEntity, T entity) {
        PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(entity);
        RelationalPersistentProperty versionProperty = (RelationalPersistentProperty)persistentEntity.getVersionProperty();
        ConversionService conversionService = this.dataAccessStrategy.getConverter().getConversionService();
        Object currentVersionValue = propertyAccessor.getProperty((PersistentProperty)versionProperty);
        long newVersionValue = 1L;
        if (currentVersionValue != null) {
            newVersionValue = (Long)conversionService.convert(currentVersionValue, Long.class) + 1L;
        }
        Class versionPropertyType = versionProperty.getType();
        propertyAccessor.setProperty((PersistentProperty)versionProperty, conversionService.convert((Object)newVersionValue, versionPropertyType));
        return (T)propertyAccessor.getBean();
    }

    private <T> Criteria createMatchingVersionCriteria(T entity, RelationalPersistentEntity<T> persistentEntity) {
        PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(entity);
        RelationalPersistentProperty versionProperty = (RelationalPersistentProperty)persistentEntity.getVersionProperty();
        Object version = propertyAccessor.getProperty((PersistentProperty)versionProperty);
        Criteria.CriteriaStep versionColumn = Criteria.where((String)this.dataAccessStrategy.toSql(versionProperty.getColumnName()));
        if (version == null) {
            return versionColumn.isNull();
        }
        return versionColumn.is(version);
    }

    @Override
    public <T> Mono<T> delete(T entity) throws DataAccessException {
        Assert.notNull(entity, (String)"Entity must not be null");
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredEntity(entity);
        return this.delete(this.getByIdQuery(entity, persistentEntity), persistentEntity.getType()).thenReturn(entity);
    }

    private <T> Query getByIdQuery(T entity, RelationalPersistentEntity<?> persistentEntity) {
        if (!persistentEntity.hasIdProperty()) {
            throw new MappingException("No id property found for object of type " + persistentEntity.getType() + "!");
        }
        IdentifierAccessor identifierAccessor = persistentEntity.getIdentifierAccessor(entity);
        Object id = identifierAccessor.getRequiredIdentifier();
        return Query.query((CriteriaDefinition)Criteria.where((String)((RelationalPersistentProperty)persistentEntity.getRequiredIdProperty()).getName()).is(id));
    }

    SqlIdentifier getTableName(Class<?> entityClass) {
        return this.getRequiredEntity((Object)entityClass).getTableName();
    }

    private RelationalPersistentEntity<?> getRequiredEntity(Class<?> entityClass) {
        return (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
    }

    private <T> RelationalPersistentEntity<T> getRequiredEntity(T entity) {
        Class entityType = ProxyUtils.getUserClass(entity);
        return this.getRequiredEntity((T)entityType);
    }

    private <T> List<Expression> getSelectProjection(Table table, Query query, Class<T> returnType) {
        if (query.getColumns().isEmpty()) {
            ProjectionInformation projectionInformation;
            if (returnType.isInterface() && (projectionInformation = this.projectionFactory.getProjectionInformation(returnType)).isClosed()) {
                return projectionInformation.getInputProperties().stream().map(FeatureDescriptor::getName).map(arg_0 -> ((Table)table).column(arg_0)).collect(Collectors.toList());
            }
            return Collections.singletonList(table.asterisk());
        }
        return query.getColumns().stream().map(arg_0 -> ((Table)table).column(arg_0)).collect(Collectors.toList());
    }

    private static ReactiveDataAccessStrategy getDataAccessStrategy(DatabaseClient databaseClient) {
        Assert.notNull((Object)databaseClient, (String)"DatabaseClient must not be null");
        if (databaseClient instanceof DefaultDatabaseClient) {
            DefaultDatabaseClient client = (DefaultDatabaseClient)databaseClient;
            return client.getDataAccessStrategy();
        }
        throw new IllegalStateException("Cannot obtain ReactiveDataAccessStrategy");
    }
}

