/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.convert.EntityRowMapper;
import org.springframework.data.r2dbc.convert.MappingR2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.core.DefaultStatementMapper;
import org.springframework.data.r2dbc.core.MapBindParameterSource;
import org.springframework.data.r2dbc.core.NamedParameterExpander;
import org.springframework.data.r2dbc.core.PreparedOperation;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.r2dbc.mapping.R2dbcMappingContext;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.r2dbc.query.UpdateMapper;
import org.springframework.data.r2dbc.support.ArrayUtils;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.RenderContextFactory;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class DefaultReactiveDataAccessStrategy
implements ReactiveDataAccessStrategy {
    private final R2dbcDialect dialect;
    private final R2dbcConverter converter;
    private final UpdateMapper updateMapper;
    private final MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
    private final StatementMapper statementMapper;
    private final NamedParameterExpander expander;

    public DefaultReactiveDataAccessStrategy(R2dbcDialect dialect) {
        this(dialect, Collections.emptyList());
    }

    public DefaultReactiveDataAccessStrategy(R2dbcDialect dialect, Collection<?> converters) {
        this(dialect, DefaultReactiveDataAccessStrategy.createConverter(dialect, converters));
    }

    public static R2dbcConverter createConverter(R2dbcDialect dialect, Collection<?> converters) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull(converters, (String)"Converters must not be null");
        ArrayList<Object> storeConverters = new ArrayList<Object>(dialect.getConverters());
        storeConverters.addAll(R2dbcCustomConversions.STORE_CONVERTERS);
        R2dbcCustomConversions customConversions = new R2dbcCustomConversions(CustomConversions.StoreConversions.of((SimpleTypeHolder)dialect.getSimpleTypeHolder(), storeConverters), converters);
        R2dbcMappingContext context = new R2dbcMappingContext();
        context.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        return new MappingR2dbcConverter((MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)context, customConversions);
    }

    public DefaultReactiveDataAccessStrategy(R2dbcDialect dialect, R2dbcConverter converter) {
        this(dialect, converter, new NamedParameterExpander());
    }

    public DefaultReactiveDataAccessStrategy(R2dbcDialect dialect, R2dbcConverter converter, NamedParameterExpander expander) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null");
        Assert.notNull((Object)expander, (String)"NamedParameterExpander must not be null");
        this.converter = converter;
        this.updateMapper = new UpdateMapper(dialect, converter);
        this.mappingContext = this.converter.getMappingContext();
        this.dialect = dialect;
        RenderContextFactory factory = new RenderContextFactory((Dialect)dialect);
        this.statementMapper = new DefaultStatementMapper(dialect, factory.createRenderContext(), this.updateMapper, this.mappingContext);
        this.expander = expander;
    }

    @Override
    public List<SqlIdentifier> getAllColumns(Class<?> entityType) {
        RelationalPersistentEntity<?> persistentEntity = this.getPersistentEntity(entityType);
        if (persistentEntity == null) {
            return Collections.singletonList(SqlIdentifier.unquoted((String)"*"));
        }
        ArrayList<SqlIdentifier> columnNames = new ArrayList<SqlIdentifier>();
        for (RelationalPersistentProperty property : persistentEntity) {
            columnNames.add(property.getColumnName());
        }
        return columnNames;
    }

    @Override
    public List<SqlIdentifier> getIdentifierColumns(Class<?> entityType) {
        RelationalPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entityType);
        ArrayList<SqlIdentifier> columnNames = new ArrayList<SqlIdentifier>();
        for (RelationalPersistentProperty property : persistentEntity) {
            if (!property.isIdProperty()) continue;
            columnNames.add(property.getColumnName());
        }
        return columnNames;
    }

    @Override
    public OutboundRow getOutboundRow(Object object) {
        Assert.notNull((Object)object, (String)"Entity object must not be null!");
        OutboundRow row = new OutboundRow();
        this.converter.write(object, row);
        RelationalPersistentEntity<?> entity = this.getRequiredPersistentEntity(ClassUtils.getUserClass((Object)object));
        for (RelationalPersistentProperty property : entity) {
            SettableValue value = row.get(property.getColumnName());
            if (value == null || !this.shouldConvertArrayValue(property, value)) continue;
            SettableValue writeValue = this.getArrayValue(value, property);
            row.put(property.getColumnName(), writeValue);
        }
        return row;
    }

    private boolean shouldConvertArrayValue(RelationalPersistentProperty property, SettableValue value) {
        if (!property.isCollectionLike()) {
            return false;
        }
        if (value.hasValue() && (value.getValue() instanceof Collection || value.getValue().getClass().isArray())) {
            return true;
        }
        return Collection.class.isAssignableFrom(value.getType()) || value.getType().isArray();
    }

    private SettableValue getArrayValue(SettableValue value, RelationalPersistentProperty property) {
        if (value.getType().equals(byte[].class)) {
            return value;
        }
        ArrayColumns arrayColumns = this.dialect.getArraySupport();
        if (!arrayColumns.isSupported()) {
            throw new InvalidDataAccessResourceUsageException("Dialect " + this.dialect.getClass().getName() + " does not support array columns");
        }
        Class actualType = null;
        if (value instanceof Collection) {
            actualType = CollectionUtils.findCommonElementType((Collection)((Collection)((Object)value)));
        } else if (value.getClass().isArray()) {
            actualType = value.getClass().getComponentType();
        }
        if (actualType == null) {
            actualType = property.getActualType();
        }
        if (value.isEmpty()) {
            Class targetType = arrayColumns.getArrayType(actualType);
            int depth = actualType.isArray() ? ArrayUtils.getDimensionDepth(actualType) : 1;
            Class<?> targetArrayType = ArrayUtils.getArrayClass(targetType, depth);
            return SettableValue.empty(targetArrayType);
        }
        return SettableValue.fromOrEmpty(this.converter.getArrayValue(arrayColumns, property, value.getValue()), actualType);
    }

    @Override
    public SettableValue getBindValue(SettableValue value) {
        return this.updateMapper.getBindValue(value);
    }

    @Override
    public <T> BiFunction<Row, RowMetadata, T> getRowMapper(Class<T> typeToRead) {
        return new EntityRowMapper<T>(typeToRead, this.converter);
    }

    @Override
    public PreparedOperation<?> processNamedParameters(String query, ReactiveDataAccessStrategy.NamedParameterProvider parameterProvider) {
        List<String> parameterNames = this.expander.getParameterNames(query);
        LinkedHashMap<String, SettableValue> namedBindings = new LinkedHashMap<String, SettableValue>(parameterNames.size());
        for (String parameterName : parameterNames) {
            SettableValue value = parameterProvider.getParameter(parameterNames.indexOf(parameterName), parameterName);
            if (value == null) {
                throw new InvalidDataAccessApiUsageException(String.format("No parameter specified for [%s] in query [%s]", parameterName, query));
            }
            namedBindings.put(parameterName, value);
        }
        return this.expander.expand(query, this.dialect.getBindMarkersFactory(), new MapBindParameterSource(namedBindings));
    }

    @Override
    public SqlIdentifier getTableName(Class<?> type) {
        return this.getRequiredPersistentEntity(type).getTableName();
    }

    @Override
    public String toSql(SqlIdentifier identifier) {
        return this.updateMapper.toSql(identifier);
    }

    @Override
    public StatementMapper getStatementMapper() {
        return this.statementMapper;
    }

    @Override
    public R2dbcConverter getConverter() {
        return this.converter;
    }

    public MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    private RelationalPersistentEntity<?> getRequiredPersistentEntity(Class<?> typeToRead) {
        return (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToRead);
    }

    @Nullable
    private RelationalPersistentEntity<?> getPersistentEntity(Class<?> typeToRead) {
        return (RelationalPersistentEntity)this.mappingContext.getPersistentEntity(typeToRead);
    }
}

