/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.r2dbc.dialect.BindMarkersFactory;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;

public class SqlServerDialect
extends org.springframework.data.relational.core.dialect.SqlServerDialect
implements R2dbcDialect {
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet<Class<UUID>>(Collections.singletonList(UUID.class));
    public static final SqlServerDialect INSTANCE = new SqlServerDialect();
    private static final BindMarkersFactory NAMED = BindMarkersFactory.named("@", "P", 32, SqlServerDialect::filterBindMarker);

    @Override
    public BindMarkersFactory getBindMarkersFactory() {
        return NAMED;
    }

    @Override
    public Collection<? extends Class<?>> getSimpleTypes() {
        return SIMPLE_TYPES;
    }

    private static String filterBindMarker(CharSequence input) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (!Character.isLetterOrDigit(ch) || ch >= '\u007f') continue;
            builder.append(ch);
        }
        if (builder.length() == 0) {
            return "";
        }
        return "_" + builder.toString();
    }
}

