/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.convert.ConversionService;

final class SingleValueMappingFunction<T>
implements BiFunction<TypeSystem, Record, T> {
    private final ConversionService conversionService;
    private final Class<T> targetClass;

    SingleValueMappingFunction(ConversionService conversionService, Class<T> targetClass) {
        this.conversionService = conversionService;
        this.targetClass = targetClass;
    }

    @Override
    public @Nullable T apply(TypeSystem typeSystem, Record record) {
        if (record.size() == 0) {
            throw new IllegalArgumentException("Record has no elements, cannot map nothing");
        }
        if (record.size() > 1) {
            throw new IllegalArgumentException("Records with more than one value cannot be converted without a mapper");
        }
        return this.convertValue(record.get(0));
    }

    @Nullable T convertValue(Value source) {
        if (this.targetClass == Void.class || this.targetClass == Void.TYPE) {
            return null;
        }
        return (T)(source == null || source == Values.NULL ? null : this.conversionService.convert((Object)source, this.targetClass));
    }
}

