/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.core.schema.Property;
import org.springframework.data.neo4j.repository.query.VectorSearchFragment;

@API(status=API.Status.INTERNAL, since="6.0.4")
public final class QueryFragments {
    private List<PatternElement> matchOn = new ArrayList<PatternElement>();
    private @Nullable Condition condition;
    private Collection<Expression> returnExpressions = new ArrayList<Expression>();
    private @Nullable Collection<SortItem> orderBy;
    private @Nullable Number limit;
    private @Nullable Long skip;
    private @Nullable ReturnTuple returnTuple;
    private boolean scalarValueReturn = false;
    private @Nullable Expression deleteExpression;
    private boolean requiresReverseSort = false;
    private @Nullable Predicate<PropertyFilter.RelaxedPropertyPath> projectingPropertyFilter;

    private static SortItem reverse(SortItem sortItem) {
        AtomicReference sortedExpression = new AtomicReference();
        AtomicReference<SortItem.Direction> sortDirection = new AtomicReference<SortItem.Direction>();
        sortItem.accept(segment -> {
            if (segment instanceof SortItem.Direction) {
                SortItem.Direction direction = (SortItem.Direction)segment;
                sortDirection.compareAndSet(null, direction == SortItem.Direction.UNDEFINED || direction == SortItem.Direction.ASC ? SortItem.Direction.DESC : SortItem.Direction.ASC);
            } else if (segment instanceof Expression) {
                Expression expression = (Expression)segment;
                sortedExpression.compareAndSet(null, expression);
            }
        });
        sortDirection.compareAndSet(null, SortItem.Direction.DESC);
        return Cypher.sort((Expression)((Expression)sortedExpression.get()), (SortItem.Direction)((SortItem.Direction)sortDirection.get()));
    }

    public void addMatchOn(PatternElement match) {
        this.matchOn.add(match);
    }

    public List<PatternElement> getMatchOn() {
        return this.matchOn;
    }

    public void setMatchOn(List<PatternElement> match) {
        this.matchOn = match;
    }

    public @Nullable Condition getCondition() {
        return this.condition;
    }

    public void setCondition(@Nullable Condition condition) {
        this.condition = Optional.ofNullable(condition).orElse(Cypher.noCondition());
    }

    public void setDeleteExpression(@Nullable Expression expression) {
        this.deleteExpression = expression;
    }

    public void setReturnExpression(@Nullable Expression returnExpression, boolean isScalarValue) {
        if (returnExpression != null) {
            this.returnExpressions = Collections.singletonList(returnExpression);
            this.scalarValueReturn = isScalarValue;
        } else {
            this.returnExpressions = List.of();
        }
    }

    public void setProjectingPropertyFilter(@Nullable Predicate<PropertyFilter.RelaxedPropertyPath> projectingPropertyFilter) {
        this.projectingPropertyFilter = projectingPropertyFilter;
    }

    public boolean includeField(PropertyFilter.RelaxedPropertyPath fieldName) {
        return !(this.projectingPropertyFilter != null && !this.projectingPropertyFilter.test(fieldName) || this.returnTuple != null && !this.returnTuple.include(fieldName));
    }

    public void setReturnBasedOn(NodeDescription<?> nodeDescription, Collection<PropertyFilter.ProjectedPath> includedProperties, boolean isDistinct, List<Expression> additionalExpressions) {
        this.returnTuple = new ReturnTuple(nodeDescription, includedProperties, isDistinct, additionalExpressions);
    }

    public boolean isScalarValueReturn() {
        return this.scalarValueReturn;
    }

    public void setRequiresReverseSort(boolean requiresReverseSort) {
        this.requiresReverseSort = requiresReverseSort;
    }

    public Statement toStatement() {
        if (this.matchOn.isEmpty()) {
            throw new IllegalStateException("No pattern to match on");
        }
        StatementBuilder.OngoingReadingWithoutWhere match = Cypher.match((PatternElement[])new PatternElement[]{this.matchOn.get(0)});
        if (this.matchOn.size() > 1) {
            for (PatternElement patternElement : this.matchOn.subList(1, this.matchOn.size())) {
                match = match.match(new PatternElement[]{patternElement});
            }
        }
        StatementBuilder.OngoingReadingWithWhere matchWithWhere = (StatementBuilder.OngoingReadingWithWhere)match.where(this.condition);
        if (this.deleteExpression != null) {
            matchWithWhere = (StatementBuilder.OngoingReadingWithWhere)matchWithWhere.detachDelete(new Expression[]{this.deleteExpression});
        }
        StatementBuilder.OngoingReadingAndReturn returnPart = this.isDistinctReturn() ? matchWithWhere.returningDistinct(this.getReturnExpressions()) : matchWithWhere.returning(this.getReturnExpressions());
        Statement statement = returnPart.orderBy(this.getOrderBy()).skip((Number)this.skip).limit(this.limit).build();
        statement.setRenderConstantsAsParameters(false);
        return statement;
    }

    public Statement toStatement(VectorSearchFragment vectorSearchFragment) {
        if (this.matchOn.isEmpty()) {
            throw new IllegalStateException("No pattern to match on");
        }
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere vectorSearch = ((StatementBuilder.OngoingStandaloneCallWithReturnFields)((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call((String)"db.index.vector.queryNodes").withArgs(new Expression[]{Cypher.literalOf((Object)vectorSearchFragment.indexName()), Cypher.literalOf((Object)vectorSearchFragment.numberOfNodes()), Cypher.parameter((String)"vectorSearchParam")})).yield(new String[]{"node", "score"})).with(new IdentifiableElement[]{Cypher.name((String)"node").as(((Node)this.matchOn.get(0)).getRequiredSymbolicName().getValue()), Cypher.name((String)"score").as("__score__")});
        StatementBuilder.OngoingReadingWithoutWhere match = vectorSearchFragment.hasScore() ? vectorSearch.where(Cypher.raw((String)"__score__", (Object[])new Object[0]).gte((Expression)Cypher.parameter((String)"scoreParam"))).match(new PatternElement[]{this.matchOn.get(0)}) : vectorSearch.match(new PatternElement[]{this.matchOn.get(0)});
        if (this.matchOn.size() > 1) {
            for (PatternElement patternElement : this.matchOn.subList(1, this.matchOn.size())) {
                match = match.match(new PatternElement[]{patternElement});
            }
        }
        StatementBuilder.OngoingReadingWithWhere matchWithWhere = (StatementBuilder.OngoingReadingWithWhere)match.where(this.condition);
        if (this.deleteExpression != null) {
            matchWithWhere = (StatementBuilder.OngoingReadingWithWhere)matchWithWhere.detachDelete(new Expression[]{this.deleteExpression});
        }
        StatementBuilder.OngoingReadingAndReturn returnPart = this.isDistinctReturn() ? matchWithWhere.returningDistinct(this.getReturnExpressionsForVectorSearch()) : matchWithWhere.returning(this.getReturnExpressionsForVectorSearch());
        Statement statement = returnPart.orderBy(this.getOrderBy()).skip((Number)this.skip).limit(this.limit).build();
        statement.setRenderConstantsAsParameters(false);
        return statement;
    }

    private Collection<Expression> getReturnExpressionsForVectorSearch() {
        return this.returnExpressions.isEmpty() && this.returnTuple != null ? CypherGenerator.INSTANCE.createReturnStatementForMatch((Neo4jPersistentEntity)this.returnTuple.nodeDescription, this::includeField, (Expression[])this.returnTuple.additionalExpressions.toArray(Expression[]::new)) : this.returnExpressions;
    }

    private Collection<Expression> getReturnExpressions() {
        return this.returnExpressions.isEmpty() && this.returnTuple != null ? CypherGenerator.INSTANCE.createReturnStatementForMatch((Neo4jPersistentEntity)this.returnTuple.nodeDescription, this::includeField, (Expression[])this.returnTuple.additionalExpressions.toArray(Expression[]::new)) : this.returnExpressions;
    }

    public void setReturnExpressions(Collection<Expression> expression) {
        this.returnExpressions = expression;
    }

    public Collection<Expression> getAdditionalReturnExpressions() {
        return this.returnTuple != null ? this.returnTuple.additionalExpressions : List.of();
    }

    private boolean isDistinctReturn() {
        return this.returnExpressions.isEmpty() && this.returnTuple != null && this.returnTuple.isDistinct;
    }

    public Collection<SortItem> getOrderBy() {
        if (this.orderBy == null) {
            return List.of();
        }
        if (!this.requiresReverseSort) {
            return this.orderBy;
        }
        return this.orderBy.stream().map(QueryFragments::reverse).toList();
    }

    public void setOrderBy(@Nullable Collection<SortItem> orderBy) {
        this.orderBy = orderBy;
    }

    public @Nullable Number getLimit() {
        return this.limit;
    }

    public void setLimit(Number limit) {
        this.limit = limit;
    }

    public @Nullable Long getSkip() {
        return this.skip;
    }

    public void setSkip(Long skip) {
        this.skip = skip;
    }

    static final class ReturnTuple {
        final NodeDescription<?> nodeDescription;
        final PropertyFilter filteredProperties;
        final boolean isDistinct;
        final List<Expression> additionalExpressions;

        private ReturnTuple(NodeDescription<?> nodeDescription, Collection<PropertyFilter.ProjectedPath> filteredProperties, boolean isDistinct, List<Expression> additionalExpressions) {
            this.nodeDescription = nodeDescription;
            this.filteredProperties = PropertyFilter.from(filteredProperties, nodeDescription);
            this.isDistinct = isDistinct;
            this.additionalExpressions = List.copyOf(additionalExpressions);
        }

        boolean include(PropertyFilter.RelaxedPropertyPath fieldName) {
            String dotPath = this.nodeDescription.getGraphProperty(fieldName.getSegment()).filter(Neo4jPersistentProperty.class::isInstance).map(Neo4jPersistentProperty.class::cast).filter(p -> p.findAnnotation(Property.class) != null).map(p -> fieldName.toDotPath(p.getPropertyName())).orElseGet(fieldName::toDotPath);
            return this.filteredProperties.contains(dotPath, fieldName.getType());
        }
    }
}

