/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.util.Assert;

final class DefaultNeo4jIsNewStrategy
implements IsNewStrategy {
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(DefaultNeo4jIsNewStrategy.class));
    private final IdDescription idDescription;
    private final Class<?> valueType;
    private final Function<Object, Object> valueLookup;

    private DefaultNeo4jIsNewStrategy(IdDescription idDescription, Class<?> valueType, Function<Object, Object> valueLookup) {
        this.idDescription = idDescription;
        this.valueType = valueType;
        this.valueLookup = valueLookup;
    }

    static IsNewStrategy basedOn(Neo4jPersistentEntity<?> entityMetaData) {
        Function<Object, Object> valueLookup;
        Assert.notNull(entityMetaData, (String)"Entity meta data must not be null");
        IdDescription idDescription = Objects.requireNonNull(entityMetaData.getIdDescription(), () -> "Cannot determine id description for entity %s".formatted(entityMetaData.getType()));
        Class<Void> valueType = ((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty()).getType();
        if (idDescription.isExternallyGeneratedId() && valueType.isPrimitive()) {
            throw new IllegalArgumentException(String.format("Cannot use %s with externally generated, primitive ids", DefaultNeo4jIsNewStrategy.class.getName()));
        }
        Neo4jPersistentProperty versionProperty = (Neo4jPersistentProperty)entityMetaData.getVersionProperty();
        if (idDescription.isAssignedId()) {
            if (versionProperty == null) {
                log.warn(() -> "Instances of " + String.valueOf(entityMetaData.getType()) + " with an assigned id will always be treated as new without version property");
                valueType = Void.class;
                valueLookup = source -> null;
            } else {
                valueType = versionProperty.getType();
                valueLookup = source -> entityMetaData.getPropertyAccessor(source).getProperty((PersistentProperty)versionProperty);
            }
        } else {
            valueLookup = source -> entityMetaData.getIdentifierAccessor(source).getIdentifier();
        }
        return new DefaultNeo4jIsNewStrategy(idDescription, valueType, valueLookup);
    }

    public boolean isNew(Object entity) {
        Object value = this.valueLookup.apply(entity);
        if (this.idDescription.isInternallyGeneratedId()) {
            boolean isNew = value != null && this.valueType.isPrimitive() && value instanceof Number ? ((Number)value).longValue() < 0L : value == null;
            return isNew;
        }
        if (this.idDescription.isExternallyGeneratedId()) {
            return value == null;
        }
        if (this.idDescription.isAssignedId()) {
            if (this.valueType != null && !this.valueType.isPrimitive()) {
                return value == null;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue() == 0L;
            }
        }
        throw new IllegalArgumentException(String.format("Could not determine whether %s is new! Unsupported identifier or version property", entity));
    }
}

