/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.reactivestreams.ReactiveQueryRunner;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.DefaultReactiveNeo4jClient;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.data.neo4j.core.ReactiveUserSelectionProvider;
import org.springframework.data.neo4j.core.UserSelection;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.transaction.Neo4jBookmarkManager;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@API(status=API.Status.STABLE, since="6.0")
public interface ReactiveNeo4jClient {
    public static final LogAccessor cypherLog = new LogAccessor(LogFactory.getLog((String)"org.springframework.data.neo4j.cypher"));
    public static final LogAccessor log = new LogAccessor(LogFactory.getLog(ReactiveNeo4jClient.class));

    public static ReactiveNeo4jClient create(Driver driver) {
        return ReactiveNeo4jClient.with(driver).build();
    }

    public static ReactiveNeo4jClient create(Driver driver, ReactiveDatabaseSelectionProvider databaseSelectionProvider) {
        return ReactiveNeo4jClient.with(driver).withDatabaseSelectionProvider(databaseSelectionProvider).build();
    }

    public static Builder with(Driver driver) {
        return new Builder(driver);
    }

    default public Mono<ReactiveQueryRunner> getQueryRunner() {
        return this.getQueryRunner((Mono<DatabaseSelection>)Mono.just((Object)DatabaseSelection.undecided()));
    }

    default public Mono<ReactiveQueryRunner> getQueryRunner(Mono<DatabaseSelection> databaseSelection) {
        return this.getQueryRunner(databaseSelection, (Mono<UserSelection>)Mono.just((Object)UserSelection.connectedUser()));
    }

    public Mono<ReactiveQueryRunner> getQueryRunner(Mono<DatabaseSelection> var1, Mono<UserSelection> var2);

    public UnboundRunnableSpec query(String var1);

    public UnboundRunnableSpec query(Supplier<String> var1);

    public <T> OngoingDelegation<T> delegateTo(Function<ReactiveQueryRunner, Mono<T>> var1);

    public @Nullable ReactiveDatabaseSelectionProvider getDatabaseSelectionProvider();

    @API(status=API.Status.STABLE, since="6.2")
    public static final class Builder {
        final Driver driver;
        @Nullable ReactiveDatabaseSelectionProvider databaseSelectionProvider;
        @Nullable ReactiveUserSelectionProvider impersonatedUserProvider;
        @Nullable Neo4jConversions neo4jConversions;
        @Nullable Neo4jBookmarkManager bookmarkManager;

        private Builder(Driver driver) {
            this.driver = driver;
        }

        public Builder withDatabaseSelectionProvider(@Nullable ReactiveDatabaseSelectionProvider databaseSelectionProvider) {
            this.databaseSelectionProvider = databaseSelectionProvider;
            return this;
        }

        public Builder withUserSelectionProvider(@Nullable ReactiveUserSelectionProvider impersonatedUserProvider) {
            this.impersonatedUserProvider = impersonatedUserProvider;
            return this;
        }

        public Builder withNeo4jConversions(@Nullable Neo4jConversions neo4jConversions) {
            this.neo4jConversions = neo4jConversions;
            return this;
        }

        public Builder withNeo4jBookmarkManager(@Nullable Neo4jBookmarkManager bookmarkManager) {
            this.bookmarkManager = bookmarkManager;
            return this;
        }

        public ReactiveNeo4jClient build() {
            return new DefaultReactiveNeo4jClient(this);
        }
    }

    public static interface RunnableDelegation<T> {
        public Mono<T> run();
    }

    public static interface OngoingDelegation<T>
    extends RunnableDelegation<T> {
        public RunnableDelegation<T> in(String var1);
    }

    public static interface RunnableSpecBoundToDatabaseAndUser
    extends RunnableSpec {
    }

    public static interface RunnableSpecBoundToUser
    extends RunnableSpec {
        public RunnableSpecBoundToDatabaseAndUser in(String var1);
    }

    public static interface RunnableSpecBoundToDatabase
    extends RunnableSpec {
        public RunnableSpecBoundToDatabaseAndUser asUser(String var1);
    }

    public static interface UnboundRunnableSpec
    extends RunnableSpec {
        public RunnableSpecBoundToDatabase in(String var1);

        public RunnableSpecBoundToUser asUser(String var1);
    }

    public static interface RunnableSpec
    extends Neo4jClient.BindSpec<RunnableSpec> {
        public <T> MappingSpec<T> fetchAs(Class<T> var1);

        public RecordFetchSpec<Map<String, Object>> fetch();

        public Mono<ResultSummary> run();
    }

    public static interface RecordFetchSpec<T> {
        public Mono<T> one();

        public Mono<T> first();

        public Flux<T> all();
    }

    public static interface MappingSpec<T>
    extends RecordFetchSpec<T> {
        public RecordFetchSpec<T> mappedBy(BiFunction<TypeSystem, Record, T> var1);
    }
}

