/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.driver.Value;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;

@API(status=API.Status.INTERNAL, since="6.0")
public final class CypherAdapterUtils {
    private CypherAdapterUtils() {
    }

    public static Function<Sort.Order, SortItem> sortAdapterFor(NodeDescription<?> nodeDescription) {
        return order -> {
            Property expression;
            SymbolicName root;
            String domainProperty = order.getProperty();
            boolean propertyIsQualifiedOrComposite = domainProperty.contains(".");
            if (!propertyIsQualifiedOrComposite) {
                root = Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription);
            } else if (nodeDescription.getGraphProperty(domainProperty.split("\\.")[0]).isEmpty()) {
                int indexOfSeparator = domainProperty.indexOf(".");
                root = Cypher.name((String)domainProperty.substring(0, indexOfSeparator));
                domainProperty = domainProperty.substring(indexOfSeparator + 1);
            } else {
                root = Constants.NAME_OF_TYPED_ROOT_NODE.apply(nodeDescription);
            }
            Optional<GraphPropertyDescription> optionalGraphProperty = nodeDescription.getGraphProperty(domainProperty);
            if (optionalGraphProperty.isEmpty()) {
                String domainPropertyPrefix = domainProperty.split("\\.")[0];
                optionalGraphProperty = nodeDescription.getGraphProperty(domainPropertyPrefix);
            }
            if (optionalGraphProperty.isEmpty()) {
                throw new IllegalStateException(String.format("Cannot order by the unknown graph property: '%s'", domainProperty));
            }
            GraphPropertyDescription graphProperty = optionalGraphProperty.get();
            if (graphProperty.isInternalIdProperty()) {
                expression = Cypher.property((Expression)root, (String[])new String[]{"__internalNeo4jId__"});
            } else {
                if (graphProperty.isComposite() && !domainProperty.contains(".")) {
                    throw new IllegalStateException(String.format("Cannot order by composite property: '%s'. Only ordering by its nested fields is allowed.", domainProperty));
                }
                if (graphProperty.isComposite()) {
                    expression = nodeDescription.containsPossibleCircles(rpp -> true) ? Cypher.property((Expression)root, (String[])new String[]{domainProperty}) : Cypher.property((Expression)root, (String[])new String[]{"__allProperties__", domainProperty});
                } else {
                    expression = Cypher.property((Expression)root, (String[])new String[]{graphProperty.getPropertyName()});
                    if (order.isIgnoreCase()) {
                        expression = Cypher.toLower((Expression)expression);
                    }
                }
            }
            SortItem sortItem = Cypher.sort((Expression)expression);
            if (order.isDescending()) {
                sortItem = sortItem.descending();
            }
            return sortItem;
        };
    }

    public static Condition combineKeysetIntoCondition(Neo4jPersistentEntity<?> entity, KeysetScrollPosition scrollPosition, Sort sort, Neo4jConversionService conversionService) {
        record PropertyAndOrder(Neo4jPersistentProperty property, Sort.Order order) {
        }
        Map incomingKeys = scrollPosition.getKeys();
        LinkedHashMap orderedKeys = new LinkedHashMap();
        HashMap propertyAndDirection = new HashMap();
        sort.forEach(order -> {
            Neo4jPersistentProperty property = (Neo4jPersistentProperty)entity.getRequiredPersistentProperty(order.getProperty());
            String propertyName = property.getPropertyName();
            propertyAndDirection.put(propertyName, new PropertyAndOrder(property, (Sort.Order)order));
            if (incomingKeys.containsKey(propertyName)) {
                orderedKeys.put(propertyName, incomingKeys.get(propertyName));
            }
        });
        if (incomingKeys.containsKey("__stable_uniq_sort__")) {
            orderedKeys.put("__stable_uniq_sort__", incomingKeys.get("__stable_uniq_sort__"));
        }
        SymbolicName root = Constants.NAME_OF_TYPED_ROOT_NODE.apply(entity);
        Condition resultingCondition = Cypher.noCondition();
        Condition nextEquals = Cypher.noCondition();
        Condition allEqualsWithArtificialSort = Cypher.noCondition();
        for (Map.Entry entry : orderedKeys.entrySet()) {
            Expression expression;
            Value value;
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null || v instanceof Value && (value = (Value)v).isNull()) {
                throw new IllegalStateException("Cannot resume from KeysetScrollPosition. Offending key: '%s' is 'null'".formatted(k));
            }
            Parameter parameter = Cypher.anonParameter((Object)conversionService.convert(v, Value.class));
            ScrollPosition.Direction scrollDirection = scrollPosition.getDirection();
            if ("__stable_uniq_sort__".equals(k)) {
                expression = entity.getIdExpression();
                BiFunction<Expression, Expression, Condition> comparatorFunction = CypherAdapterUtils.getComparatorFunction(scrollPosition.scrollsForward() ? Sort.Direction.ASC : Sort.Direction.DESC, scrollDirection);
                allEqualsWithArtificialSort = allEqualsWithArtificialSort.and(comparatorFunction.apply(expression, (Expression)parameter));
                continue;
            }
            if (!propertyAndDirection.containsKey(k)) continue;
            PropertyAndOrder p = (PropertyAndOrder)propertyAndDirection.get(k);
            expression = p.property.isIdProperty() ? entity.getIdExpression() : root.property(k);
            BiFunction<Expression, Expression, Condition> comparatorFunction = CypherAdapterUtils.getComparatorFunction(p.order.getDirection(), scrollDirection);
            resultingCondition = resultingCondition.or(nextEquals.and(comparatorFunction.apply(expression, (Expression)parameter)));
            nextEquals = expression.eq((Expression)parameter);
            allEqualsWithArtificialSort = allEqualsWithArtificialSort.and(nextEquals);
        }
        return resultingCondition.or(allEqualsWithArtificialSort);
    }

    private static BiFunction<Expression, Expression, Condition> getComparatorFunction(Sort.Direction sortDirection, ScrollPosition.Direction scrollDirection) {
        if (scrollDirection == ScrollPosition.Direction.BACKWARD) {
            return sortDirection.isAscending() ? Expression::lte : Expression::gte;
        }
        return sortDirection.isAscending() ? Expression::gt : Expression::lt;
    }

    public static Collection<SortItem> toSortItems(@Nullable NodeDescription<?> nodeDescription, Sort sort) {
        if (nodeDescription == null) {
            return List.of();
        }
        return sort.stream().map(CypherAdapterUtils.sortAdapterFor(nodeDescription)).collect(Collectors.toList());
    }
}

