/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.Point;
import org.springframework.data.convert.ConverterBuilder;
import org.springframework.data.neo4j.types.CartesianPoint2d;
import org.springframework.data.neo4j.types.CartesianPoint3d;
import org.springframework.data.neo4j.types.Coordinate;
import org.springframework.data.neo4j.types.GeographicPoint2d;
import org.springframework.data.neo4j.types.GeographicPoint3d;
import org.springframework.data.neo4j.types.Neo4jPoint;
import org.springframework.data.neo4j.types.PointBuilder;
import org.springframework.util.Assert;

final class SpatialTypes {
    static final List<?> CONVERTERS;

    private SpatialTypes() {
    }

    static Neo4jPoint asNeo4jPoint(Value value) {
        Point point = value.asPoint();
        Coordinate coordinate = new Coordinate(point.x(), point.y(), Double.isNaN(point.z()) ? null : Double.valueOf(point.z()));
        return PointBuilder.withSrid(point.srid()).build(coordinate);
    }

    static Value value(Neo4jPoint object) {
        if (object instanceof CartesianPoint2d) {
            CartesianPoint2d point = (CartesianPoint2d)object;
            return Values.point((int)point.getSrid(), (double)point.getX(), (double)point.getY());
        }
        if (object instanceof CartesianPoint3d) {
            CartesianPoint3d point = (CartesianPoint3d)object;
            return Values.point((int)point.getSrid(), (double)point.getX(), (double)point.getY(), (double)point.getZ());
        }
        if (object instanceof GeographicPoint2d) {
            GeographicPoint2d point = (GeographicPoint2d)object;
            return Values.point((int)point.getSrid(), (double)point.getLongitude(), (double)point.getLatitude());
        }
        if (object instanceof GeographicPoint3d) {
            GeographicPoint3d point = (GeographicPoint3d)object;
            return Values.point((int)point.getSrid(), (double)point.getLongitude(), (double)point.getLatitude(), (double)point.getHeight());
        }
        throw new IllegalArgumentException("Unsupported point implementation: " + String.valueOf(object.getClass()));
    }

    static org.springframework.data.geo.Point asSpringDataPoint(Value value) {
        Point point = value.asPoint();
        Assert.isTrue((point.srid() == 4326 ? 1 : 0) != 0, (String)"Srid must be 4326");
        return new org.springframework.data.geo.Point(point.y(), point.x());
    }

    static Value value(org.springframework.data.geo.Point point) {
        return Values.point((int)4326, (double)point.getY(), (double)point.getX());
    }

    static org.springframework.data.geo.Point[] asPointArray(Value value) {
        org.springframework.data.geo.Point[] array = new org.springframework.data.geo.Point[value.size()];
        int i2 = 0;
        for (org.springframework.data.geo.Point v : value.values(SpatialTypes::asSpringDataPoint)) {
            array[i2++] = v;
        }
        return array;
    }

    static Value value(org.springframework.data.geo.Point[] aPointArray) {
        if (aPointArray == null) {
            return Values.NULL;
        }
        Value[] values = new Value[aPointArray.length];
        int i2 = 0;
        for (org.springframework.data.geo.Point v : aPointArray) {
            values[i2++] = SpatialTypes.value(v);
        }
        return Values.value((Value[])values);
    }

    static {
        ArrayList<ConverterBuilder.ConverterAware> hlp = new ArrayList<ConverterBuilder.ConverterAware>();
        hlp.add(ConverterBuilder.reading(Value.class, org.springframework.data.geo.Point.class, SpatialTypes::asSpringDataPoint).andWriting(SpatialTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, org.springframework.data.geo.Point[].class, SpatialTypes::asPointArray).andWriting(SpatialTypes::value));
        hlp.add(ConverterBuilder.reading(Value.class, Neo4jPoint.class, SpatialTypes::asNeo4jPoint).andWriting(SpatialTypes::value));
        CONVERTERS = Collections.unmodifiableList(hlp);
    }
}

