/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Objects;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;

@API(status=API.Status.STABLE, since="6.0")
public final class DatabaseSelection {
    private static final DatabaseSelection DEFAULT_DATABASE_NAME = new DatabaseSelection(null);
    private final @Nullable String value;

    private DatabaseSelection(@Nullable String value) {
        this.value = value;
    }

    public static DatabaseSelection undecided() {
        return DEFAULT_DATABASE_NAME;
    }

    public static DatabaseSelection byName(String databaseName) {
        return new DatabaseSelection(databaseName);
    }

    public @Nullable String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseSelection that = (DatabaseSelection)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

