/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.types;

import org.apiguardian.api.API;
import org.springframework.data.neo4j.types.CartesianPoint2d;
import org.springframework.data.neo4j.types.CartesianPoint3d;
import org.springframework.data.neo4j.types.Coordinate;
import org.springframework.data.neo4j.types.GeographicPoint2d;
import org.springframework.data.neo4j.types.GeographicPoint3d;
import org.springframework.data.neo4j.types.Neo4jPoint;

@API(status=API.Status.STABLE, since="6.0")
public final class PointBuilder {
    private final int srid;

    private PointBuilder(int srid) {
        this.srid = srid;
    }

    public static PointBuilder withSrid(int srid) {
        return new PointBuilder(srid);
    }

    public Neo4jPoint build(Coordinate coordinate) {
        boolean is3d;
        boolean bl = is3d = coordinate.getZ() != null;
        if (this.srid == 7203 || this.srid == 9157) {
            return is3d ? new CartesianPoint3d(coordinate) : new CartesianPoint2d(coordinate);
        }
        return is3d ? new GeographicPoint3d(coordinate, this.srid) : new GeographicPoint2d(coordinate, (Integer)this.srid);
    }
}

