/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.io.Serializable;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.support.ReactiveNeo4jRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;

@API(status=API.Status.INTERNAL, since="6.0")
public final class ReactiveNeo4jRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID> {
    private @Nullable ReactiveNeo4jOperations neo4jOperations;
    private @Nullable Neo4jMappingContext neo4jMappingContext;

    ReactiveNeo4jRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setNeo4jOperations(@Nullable ReactiveNeo4jOperations neo4jOperations) {
        this.neo4jOperations = neo4jOperations;
    }

    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.neo4jMappingContext = (Neo4jMappingContext)mappingContext;
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        if (this.neo4jOperations == null || this.neo4jMappingContext == null) {
            throw new IllegalStateException("Repository factory bean has not been configured properly, both Neo4j operations and mapping context are required");
        }
        return new ReactiveNeo4jRepositoryFactory(this.neo4jOperations, this.neo4jMappingContext);
    }
}

