/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.convert;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.function.BiFunction;
import java.util.function.Function;

final class TemporalAmountAdapter
implements Function<TemporalAmount, TemporalAmount> {
    private static final int PERIOD_MASK = 28;
    private static final int DURATION_MASK = 3;
    private static final TemporalUnit[] SUPPORTED_UNITS = new TemporalUnit[]{ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS};
    private static final short FIELD_YEAR = 0;
    private static final short FIELD_MONTH = 1;
    private static final short FIELD_DAY = 2;
    private static final short FIELD_SECONDS = 3;
    private static final short FIELD_NANOS = 4;
    private static final BiFunction<TemporalAmount, TemporalUnit, Integer> TEMPORAL_UNIT_EXTRACTOR = (d, u) -> {
        if (!d.getUnits().contains(u)) {
            return 0;
        }
        return Math.toIntExact(d.get((TemporalUnit)u));
    };

    TemporalAmountAdapter() {
    }

    private static boolean couldBePeriod(int type) {
        return (0x1C & type) > 0;
    }

    private static boolean couldBeDuration(int type) {
        return (3 & type) > 0;
    }

    @Override
    public TemporalAmount apply(TemporalAmount internalTemporalAmountRepresentation) {
        int[] values = new int[SUPPORTED_UNITS.length];
        int type = 0;
        for (int i2 = 0; i2 < SUPPORTED_UNITS.length; ++i2) {
            values[i2] = TEMPORAL_UNIT_EXTRACTOR.apply(internalTemporalAmountRepresentation, SUPPORTED_UNITS[i2]);
            type |= values[i2] == 0 ? 0 : 16 >> i2;
        }
        boolean couldBePeriod = TemporalAmountAdapter.couldBePeriod(type);
        boolean couldBeDuration = TemporalAmountAdapter.couldBeDuration(type);
        if (couldBePeriod && !couldBeDuration) {
            return Period.of(values[0], values[1], values[2]).normalized();
        }
        if (couldBeDuration && !couldBePeriod) {
            return Duration.ofSeconds(values[3]).plusNanos(values[4]);
        }
        return internalTemporalAmountRepresentation;
    }
}

