/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.schema.TargetNode;

@API(status=API.Status.INTERNAL, since="6.3")
public final class AssociationHandlerSupport {
    private static final Map<Neo4jPersistentEntity<?>, AssociationHandlerSupport> CACHE = new ConcurrentHashMap();
    private final Neo4jPersistentEntity<?> entity;

    private AssociationHandlerSupport(Neo4jPersistentEntity<?> entity) {
        this.entity = entity;
    }

    public static AssociationHandlerSupport of(Neo4jPersistentEntity<?> entity) {
        return CACHE.computeIfAbsent(entity, AssociationHandlerSupport::new);
    }

    public Neo4jPersistentEntity<?> doWithAssociations(AssociationHandler<Neo4jPersistentProperty> handler) {
        this.entity.doWithAssociations(association -> {
            if (!((Neo4jPersistentProperty)association.getInverse()).isAnnotationPresent(TargetNode.class)) {
                handler.doWithAssociation(association);
            }
        });
        return this.entity;
    }
}

