/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.io.Serializable;
import org.apiguardian.api.API;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.support.Neo4jRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;

@API(status=API.Status.INTERNAL, since="6.0")
public final class Neo4jRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID> {
    private Neo4jOperations neo4jOperations;
    private Neo4jMappingContext neo4jMappingContext;

    protected Neo4jRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setNeo4jOperations(Neo4jOperations neo4jOperations) {
        this.neo4jOperations = neo4jOperations;
    }

    public void setNeo4jMappingContext(Neo4jMappingContext neo4jMappingContext) {
        super.setMappingContext((MappingContext)neo4jMappingContext);
        this.neo4jMappingContext = neo4jMappingContext;
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        return new Neo4jRepositoryFactory(this.neo4jOperations, this.neo4jMappingContext);
    }
}

