/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Optional;
import org.springframework.core.ResolvableType;
import org.springframework.data.annotation.ReadOnlyProperty;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.core.convert.ConvertWith;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.mapping.DefaultRelationshipDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PersistentPropertyCharacteristics;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.schema.CompositeProperty;
import org.springframework.data.neo4j.core.schema.Relationship;
import org.springframework.data.neo4j.core.schema.RelationshipProperties;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class DefaultNeo4jPersistentProperty
extends AnnotationBasedPersistentProperty<Neo4jPersistentProperty>
implements Neo4jPersistentProperty {
    private final Lazy<String> graphPropertyName;
    private final Lazy<Boolean> isWritableProperty;
    private final Lazy<Boolean> isAssociation;
    private final Neo4jMappingContext mappingContext;
    private final Lazy<Neo4jPersistentPropertyConverter<?>> customConversion;
    @Nullable
    private final PersistentPropertyCharacteristics optionalCharacteristics;

    DefaultNeo4jPersistentProperty(Property property, PersistentEntity<?, Neo4jPersistentProperty> owner, Neo4jMappingContext mappingContext, SimpleTypeHolder simpleTypeHolder, @Nullable PersistentPropertyCharacteristics optionalCharacteristics) {
        super(property, owner, simpleTypeHolder);
        this.mappingContext = mappingContext;
        this.graphPropertyName = Lazy.of(this::computeGraphPropertyName);
        this.isWritableProperty = Lazy.of(() -> {
            Class targetType = this.getActualType();
            return simpleTypeHolder.isSimpleType(targetType) || this.mappingContext.hasCustomWriteTarget(targetType) || this.isAnnotationPresent(ConvertWith.class) || this.isComposite();
        });
        this.isAssociation = Lazy.of(() -> {
            if (this.isAnnotationPresent(Relationship.class)) {
                return true;
            }
            return (Boolean)this.isWritableProperty.get() == false;
        });
        this.customConversion = Lazy.of(() -> {
            if (this.isEntity()) {
                return null;
            }
            return this.mappingContext.getOptionalCustomConversionsFor(this);
        });
        this.optionalCharacteristics = optionalCharacteristics;
    }

    protected Association<Neo4jPersistentProperty> createAssociation() {
        Neo4jPersistentEntity<?> obverseOwner;
        boolean dynamicAssociation = this.isDynamicAssociation();
        Neo4jPersistentEntity<?> relationshipPropertiesClass = null;
        if (this.hasActualTypeAnnotation(RelationshipProperties.class)) {
            TypeInformation<?> typeInformation = this.getRelationshipPropertiesTargetType(this.getActualType());
            obverseOwner = this.mappingContext.addPersistentEntity(typeInformation).get();
            relationshipPropertiesClass = this.mappingContext.addPersistentEntity(TypeInformation.of((Class)this.getActualType())).get();
        } else {
            Class<?> associationTargetType = this.getAssociationTargetType();
            obverseOwner = this.mappingContext.addPersistentEntity(TypeInformation.of(associationTargetType)).orElse(null);
            Assert.notNull((Object)obverseOwner, (String)"Obverse owner could not be added");
            if (dynamicAssociation) {
                TypeInformation mapValueType = this.getTypeInformation().getMapValueType();
                boolean relationshipPropertiesCollection = ((Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(mapValueType.getActualType().getType())).isRelationshipPropertiesEntity();
                boolean relationshipPropertiesScalar = mapValueType.getType().isAnnotationPresent(RelationshipProperties.class);
                if (relationshipPropertiesCollection) {
                    TypeInformation<?> typeInformation = this.getRelationshipPropertiesTargetType(mapValueType.getActualType().getType());
                    obverseOwner = this.mappingContext.addPersistentEntity(typeInformation).get();
                    relationshipPropertiesClass = this.mappingContext.addPersistentEntity(mapValueType.getComponentType()).get();
                } else if (relationshipPropertiesScalar) {
                    relationshipPropertiesClass = this.mappingContext.addPersistentEntity(mapValueType.getComponentType()).get();
                }
            }
        }
        Relationship relationship = (Relationship)this.findAnnotation(Relationship.class);
        String type = relationship != null && StringUtils.hasText((String)relationship.type()) ? relationship.type() : DefaultNeo4jPersistentProperty.deriveRelationshipType(this.getName());
        Relationship.Direction direction = relationship != null ? relationship.direction() : Relationship.Direction.OUTGOING;
        Optional<RelationshipDescription> obverseRelationshipDescription = obverseOwner.getRelationships().stream().filter(rel -> rel.getType().equals(type) && rel.getTarget().equals(this.getOwner()) && rel.getDirection() == direction.opposite()).findFirst();
        DefaultRelationshipDescription relationshipDescription = new DefaultRelationshipDescription(this, obverseRelationshipDescription.orElse(null), type, dynamicAssociation, (NodeDescription)this.getOwner(), this.getName(), obverseOwner, direction, relationshipPropertiesClass, relationship == null || relationship.cascadeUpdates());
        obverseRelationshipDescription.ifPresent(observeRelationship -> observeRelationship.setRelationshipObverse(relationshipDescription));
        return relationshipDescription;
    }

    @NonNull
    private TypeInformation<?> getRelationshipPropertiesTargetType(Class<?> relationshipPropertiesType) {
        ParameterizedType pt;
        Type type;
        Field targetNodeField = ReflectionUtils.findField(relationshipPropertiesType, field -> field.isAnnotationPresent(TargetNode.class));
        if (targetNodeField == null) {
            throw new MappingException("Missing @TargetNode declaration in " + relationshipPropertiesType);
        }
        TypeInformation relationshipPropertiesTypeInformation = TypeInformation.of(relationshipPropertiesType);
        Class type2 = relationshipPropertiesTypeInformation.getProperty(targetNodeField.getName()).getType();
        if (Object.class == type2 && (type = this.getField().getGenericType()) instanceof ParameterizedType && (pt = (ParameterizedType)type).getActualTypeArguments().length == 1) {
            return TypeInformation.of((ResolvableType)ResolvableType.forType((Type)pt.getActualTypeArguments()[0]));
        }
        return TypeInformation.of((Class)type2);
    }

    public Class<?> getAssociationTargetType() {
        if (this.isDynamicOneToManyAssociation()) {
            TypeInformation actualType = this.getTypeInformation().getRequiredActualType();
            return actualType.getRequiredComponentType().getType();
        }
        return this.getActualType();
    }

    public boolean isAssociation() {
        return (Boolean)this.isAssociation.or((Object)false).get();
    }

    public boolean isEntity() {
        return super.isEntity() && (Boolean)this.isWritableProperty.get() == false && !this.isAnnotationPresent(ConvertWith.class);
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypeInformation() {
        return this.isAnnotationPresent(ConvertWith.class) ? Collections.emptyList() : super.getPersistentEntityTypeInformation();
    }

    @Override
    public boolean isEntityWithRelationshipProperties() {
        return this.isEntity() && ((Neo4jPersistentEntity)this.getOwner()).isRelationshipPropertiesEntity();
    }

    @Override
    public Neo4jPersistentPropertyConverter<?> getOptionalConverter() {
        return this.isEntity() ? null : (Neo4jPersistentPropertyConverter)this.customConversion.getOptional().map(Neo4jPersistentPropertyConverter.class::cast).orElse(null);
    }

    @Nullable
    private String computeGraphPropertyName() {
        if (this.isRelationship()) {
            return null;
        }
        org.springframework.data.neo4j.core.schema.Property propertyAnnotation = (org.springframework.data.neo4j.core.schema.Property)this.findAnnotation(org.springframework.data.neo4j.core.schema.Property.class);
        String targetName = this.getName();
        if (propertyAnnotation != null && !propertyAnnotation.name().isEmpty() && propertyAnnotation.name().trim().length() != 0) {
            targetName = propertyAnnotation.name().trim();
        }
        return targetName;
    }

    @Override
    public String getFieldName() {
        return this.getName();
    }

    @Override
    public String getPropertyName() {
        String propertyName = (String)this.graphPropertyName.getNullable();
        if (propertyName == null) {
            throw new MappingException("The attribute '" + this.getFieldName() + "' is not mapped to a Graph property");
        }
        return propertyName;
    }

    @Override
    public boolean isInternalIdProperty() {
        return this.isIdProperty() && ((Neo4jPersistentEntity)this.getOwner()).isUsingInternalIds();
    }

    @Override
    public boolean isRelationship() {
        return this.isAssociation() && !this.isAnnotationPresent(TargetNode.class);
    }

    @Override
    public boolean isComposite() {
        return this.isAnnotationPresent(CompositeProperty.class);
    }

    static String deriveRelationshipType(String name) {
        int codePoint;
        Assert.hasText((String)name, (String)"The name to derive the type from is required");
        StringBuilder sb = new StringBuilder();
        int previousIndex = 0;
        for (int i2 = 0; i2 < name.length(); i2 += Character.charCount(codePoint)) {
            codePoint = name.codePointAt(i2);
            if (Character.isLowerCase(codePoint)) {
                if (i2 > 0 && !Character.isLetter(name.codePointAt(previousIndex))) {
                    sb.append("_");
                }
                codePoint = Character.toUpperCase(codePoint);
            } else if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(Character.toChars(codePoint));
            previousIndex = i2;
        }
        return sb.toString();
    }

    @Override
    public boolean isReadOnly() {
        if (this.optionalCharacteristics != null && this.optionalCharacteristics.isReadOnly() != null) {
            return Boolean.TRUE.equals(this.optionalCharacteristics.isReadOnly());
        }
        Class<org.springframework.data.neo4j.core.schema.Property> typeOfAnnotation = org.springframework.data.neo4j.core.schema.Property.class;
        return this.isAnnotationPresent(ReadOnlyProperty.class) || this.isAnnotationPresent(typeOfAnnotation) && ((org.springframework.data.neo4j.core.schema.Property)this.getRequiredAnnotation(typeOfAnnotation)).readOnly();
    }

    public boolean isTransient() {
        return this.optionalCharacteristics == null || this.optionalCharacteristics.isTransient() == null ? super.isTransient() : Boolean.TRUE.equals(this.optionalCharacteristics.isTransient());
    }
}

