/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.repository.query.AbstractReactiveNeo4jQuery;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQuerySupport;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.neo4j.repository.query.Neo4jSpelSupport;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.neo4j.repository.query.StringBasedNeo4jQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.SpelQueryContext;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.ValueExpressionQueryRewriter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class ReactiveStringBasedNeo4jQuery
extends AbstractReactiveNeo4jQuery {
    static final SpelQueryContext SPEL_QUERY_CONTEXT = SpelQueryContext.of(ReactiveStringBasedNeo4jQuery::parameterNameSource, ReactiveStringBasedNeo4jQuery::replacementSource);
    private final ValueExpressionQueryRewriter.EvaluatingValueExpressionQueryRewriter queryRewriter;
    private final ValueExpressionQueryRewriter.QueryExpressionEvaluator parsedQuery;

    static ReactiveStringBasedNeo4jQuery create(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, ValueExpressionDelegate delegate, Neo4jQueryMethod queryMethod, ProjectionFactory factory) {
        Query queryAnnotation = queryMethod.getQueryAnnotation().orElseThrow(() -> new MappingException("Expected @Query annotation on the query method"));
        String cypherTemplate = Optional.ofNullable(queryAnnotation.value()).filter(StringUtils::hasText).orElseThrow(() -> new MappingException("Expected @Query annotation to have a value, but it did not"));
        return new ReactiveStringBasedNeo4jQuery(neo4jOperations, mappingContext, delegate, queryMethod, cypherTemplate, Neo4jQueryType.fromDefinition(queryAnnotation), factory);
    }

    static ReactiveStringBasedNeo4jQuery create(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, ValueExpressionDelegate delegate, Neo4jQueryMethod queryMethod, String cypherTemplate, ProjectionFactory factory) {
        Assert.hasText((String)cypherTemplate, (String)"Cannot create String based Neo4j query without a cypher template");
        return new ReactiveStringBasedNeo4jQuery(neo4jOperations, mappingContext, delegate, queryMethod, cypherTemplate, Neo4jQueryType.DEFAULT, factory);
    }

    private ReactiveStringBasedNeo4jQuery(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, ValueExpressionDelegate delegate, Neo4jQueryMethod queryMethod, String cypherTemplate, Neo4jQueryType queryType, ProjectionFactory factory) {
        super(neo4jOperations, mappingContext, queryMethod, queryType, factory);
        this.queryRewriter = ValueExpressionQueryRewriter.of((ValueExpressionDelegate)delegate, StringBasedNeo4jQuery::parameterNameSource, StringBasedNeo4jQuery::replacementSource);
        this.parsedQuery = this.queryRewriter.parse(cypherTemplate, queryMethod.getParameters());
    }

    @Override
    protected <T> PreparedQuery<T> prepareQuery(Class<T> returnedType, Collection<PropertyFilter.ProjectedPath> includedProperties, Neo4jParameterAccessor parameterAccessor, @Nullable Neo4jQueryType queryType, @Nullable Supplier<BiFunction<TypeSystem, MapAccessor, ?>> mappingFunction, @Nullable UnaryOperator<Integer> limitModifier) {
        Map<String, Object> boundParameters = this.bindParameters(parameterAccessor);
        Neo4jQuerySupport.QueryContext queryContext = new Neo4jQuerySupport.QueryContext(this.queryMethod.getRepositoryName() + "." + this.queryMethod.getName(), this.parsedQuery.getQueryString(), boundParameters);
        this.logWarningsIfNecessary(queryContext, parameterAccessor);
        return PreparedQuery.queryFor(returnedType).withCypherQuery(queryContext.query).withParameters(boundParameters).usingMappingFunction(mappingFunction).build();
    }

    Map<String, Object> bindParameters(Neo4jParameterAccessor parameterAccessor) {
        Parameters<Neo4jQueryMethod.Neo4jParameters, Neo4jQueryMethod.Neo4jParameter> formalParameters = parameterAccessor.getParameters();
        HashMap<String, Object> resolvedParameters = new HashMap<String, Object>();
        for (Map.Entry evaluatedParam : this.parsedQuery.evaluate(parameterAccessor.getValues()).entrySet()) {
            Object value = evaluatedParam.getValue();
            if (!(evaluatedParam.getValue() instanceof Neo4jSpelSupport.LiteralReplacement)) {
                Neo4jQuerySupport.logParameterIfNull((String)evaluatedParam.getKey(), value);
                value = super.convertParameter(evaluatedParam.getValue());
            }
            resolvedParameters.put((String)evaluatedParam.getKey(), value);
        }
        formalParameters.stream().filter(Parameter::isBindable).forEach(parameter -> {
            int index = parameter.getIndex();
            Object value = parameterAccessor.getBindableValue(index);
            Neo4jQuerySupport.logParameterIfNull(parameter.getName().orElseGet(() -> Integer.toString(index)), value);
            Object convertedValue = super.convertParameter(value);
            parameter.getName().ifPresent(parameterName -> resolvedParameters.put((String)parameterName, convertedValue));
            resolvedParameters.put(Integer.toString(index), convertedValue);
        });
        return resolvedParameters;
    }

    private static String parameterNameSource(int index, String originalSpelExpression) {
        return "__SpEL__" + index;
    }

    private static String replacementSource(String originalPrefix, String parameterName) {
        return "$" + parameterName;
    }
}

