/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Query;
import org.neo4j.driver.QueryRunner;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.DatabaseSelectionProvider;
import org.springframework.data.neo4j.core.NamedParameters;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jPersistenceExceptionTranslator;
import org.springframework.data.neo4j.core.ResultSummaries;
import org.springframework.data.neo4j.core.SingleValueMappingFunction;
import org.springframework.data.neo4j.core.UserSelection;
import org.springframework.data.neo4j.core.UserSelectionProvider;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.support.BookmarkManagerReference;
import org.springframework.data.neo4j.core.transaction.Neo4jBookmarkManager;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class DefaultNeo4jClient
implements Neo4jClient,
ApplicationContextAware {
    private final Driver driver;
    @Nullable
    private final DatabaseSelectionProvider databaseSelectionProvider;
    @Nullable
    private final UserSelectionProvider userSelectionProvider;
    private final ConversionService conversionService;
    private final Neo4jPersistenceExceptionTranslator persistenceExceptionTranslator = new Neo4jPersistenceExceptionTranslator();
    private final BookmarkManagerReference bookmarkManager;

    DefaultNeo4jClient(Neo4jClient.Builder builder) {
        this.driver = builder.driver;
        this.databaseSelectionProvider = builder.databaseSelectionProvider;
        this.userSelectionProvider = builder.userSelectionProvider;
        this.bookmarkManager = new BookmarkManagerReference(Neo4jBookmarkManager::create, builder.bookmarkManager);
        this.conversionService = new DefaultConversionService();
        Optional.ofNullable(builder.neo4jConversions).orElseGet(Neo4jConversions::new).registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    @Override
    public QueryRunner getQueryRunner(DatabaseSelection databaseSelection, UserSelection impersonatedUser) {
        Transaction queryRunner = Neo4jTransactionManager.retrieveTransaction(this.driver, databaseSelection, impersonatedUser);
        Collection<Bookmark> lastBookmarks = this.bookmarkManager.resolve().getBookmarks();
        if (queryRunner == null) {
            queryRunner = this.driver.session(Neo4jTransactionUtils.sessionConfig(false, lastBookmarks, databaseSelection, impersonatedUser));
        }
        return new DelegatingQueryRunner((QueryRunner)queryRunner, lastBookmarks, this.bookmarkManager.resolve()::updateBookmarks);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.bookmarkManager.setApplicationContext(applicationContext);
    }

    @Override
    public Neo4jClient.UnboundRunnableSpec query(String cypher) {
        return this.query(() -> cypher);
    }

    @Override
    public Neo4jClient.UnboundRunnableSpec query(Supplier<String> cypherSupplier) {
        return new DefaultRunnableSpec(cypherSupplier);
    }

    @Override
    public <T> Neo4jClient.OngoingDelegation<T> delegateTo(Function<QueryRunner, Optional<T>> callback) {
        return new DefaultRunnableDelegation<T>(callback);
    }

    @Override
    @Nullable
    public DatabaseSelectionProvider getDatabaseSelectionProvider() {
        return this.databaseSelectionProvider;
    }

    private static RuntimeException potentiallyConvertRuntimeException(RuntimeException ex, PersistenceExceptionTranslator exceptionTranslator) {
        DataAccessException resolved = exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    private DatabaseSelection resolveTargetDatabaseName(@Nullable String parameterTargetDatabase) {
        String value = Neo4jClient.verifyDatabaseName(parameterTargetDatabase);
        if (value != null) {
            return DatabaseSelection.byName(value);
        }
        if (this.databaseSelectionProvider != null) {
            return this.databaseSelectionProvider.getDatabaseSelection();
        }
        return DatabaseSelectionProvider.getDefaultSelectionProvider().getDatabaseSelection();
    }

    private UserSelection resolveUser(@Nullable String userName) {
        if (StringUtils.hasText((String)userName)) {
            return UserSelection.impersonate(userName);
        }
        if (this.userSelectionProvider != null) {
            return this.userSelectionProvider.getUserSelection();
        }
        return UserSelectionProvider.getDefaultSelectionProvider().getUserSelection();
    }

    private static class DelegatingQueryRunner
    implements QueryRunner {
        private final QueryRunner delegate;
        private final Collection<Bookmark> usedBookmarks;
        private final BiConsumer<Collection<Bookmark>, Collection<Bookmark>> newBookmarkConsumer;

        private DelegatingQueryRunner(QueryRunner delegate, Collection<Bookmark> lastBookmarks, BiConsumer<Collection<Bookmark>, Collection<Bookmark>> newBookmarkConsumer) {
            this.delegate = delegate;
            this.usedBookmarks = lastBookmarks;
            this.newBookmarkConsumer = newBookmarkConsumer;
        }

        public void close() {
            QueryRunner queryRunner = this.delegate;
            if (queryRunner instanceof Session) {
                Session session = (Session)queryRunner;
                session.close();
                this.newBookmarkConsumer.accept(this.usedBookmarks, session.lastBookmarks());
            }
        }

        public Result run(String s, Value value) {
            return this.delegate.run(s, value);
        }

        public Result run(String s, Map<String, Object> map) {
            return this.delegate.run(s, map);
        }

        public Result run(String s, Record record) {
            return this.delegate.run(s, record);
        }

        public Result run(String s) {
            return this.delegate.run(s);
        }

        public Result run(Query query) {
            return this.delegate.run(query);
        }
    }

    class DefaultRunnableSpec
    implements Neo4jClient.UnboundRunnableSpec,
    Neo4jClient.RunnableSpecBoundToDatabaseAndUser {
        private final RunnableStatement runnableStatement;
        private DatabaseSelection databaseSelection;
        private UserSelection userSelection;

        DefaultRunnableSpec(Supplier<String> cypherSupplier) {
            this.databaseSelection = DefaultNeo4jClient.this.resolveTargetDatabaseName(null);
            this.userSelection = DefaultNeo4jClient.this.resolveUser(null);
            this.runnableStatement = new RunnableStatement(cypherSupplier);
        }

        @Override
        public Neo4jClient.RunnableSpecBoundToDatabase in(String targetDatabase) {
            this.databaseSelection = DefaultNeo4jClient.this.resolveTargetDatabaseName(targetDatabase);
            return new DefaultRunnableSpecBoundToDatabase();
        }

        @Override
        public Neo4jClient.RunnableSpecBoundToUser asUser(String asUser) {
            this.userSelection = DefaultNeo4jClient.this.resolveUser(asUser);
            return new DefaultRunnableSpecBoundToUser();
        }

        @Override
        public <T> Neo4jClient.OngoingBindSpec<T, Neo4jClient.RunnableSpec> bind(T value) {
            return new DefaultOngoingBindSpec<T>(value);
        }

        @Override
        public Neo4jClient.RunnableSpec bindAll(Map<String, Object> newParameters) {
            this.runnableStatement.parameters.addAll(newParameters);
            return this;
        }

        @Override
        public <T> Neo4jClient.MappingSpec<T> fetchAs(Class<T> targetClass) {
            return new DefaultRecordFetchSpec(this.databaseSelection, this.userSelection, this.runnableStatement, new SingleValueMappingFunction<T>(DefaultNeo4jClient.this.conversionService, targetClass));
        }

        @Override
        public Neo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
            return new DefaultRecordFetchSpec<Map<String, Object>>(this.databaseSelection, this.userSelection, this.runnableStatement, (t, r) -> r.asMap());
        }

        @Override
        public ResultSummary run() {
            ResultSummary resultSummary;
            block9: {
                QueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.databaseSelection, this.userSelection);
                try {
                    Result result = this.runnableStatement.runWith(statementRunner);
                    resultSummary = ResultSummaries.process(result.consume());
                    if (statementRunner == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (statementRunner != null) {
                            try {
                                statementRunner.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                statementRunner.close();
            }
            return resultSummary;
        }

        class DefaultRunnableSpecBoundToDatabase
        implements Neo4jClient.RunnableSpecBoundToDatabase {
            DefaultRunnableSpecBoundToDatabase() {
            }

            @Override
            public Neo4jClient.RunnableSpecBoundToDatabaseAndUser asUser(String aUser) {
                DefaultRunnableSpec.this.userSelection = DefaultNeo4jClient.this.resolveUser(aUser);
                return DefaultRunnableSpec.this;
            }

            @Override
            public <T> Neo4jClient.MappingSpec<T> fetchAs(Class<T> targetClass) {
                return DefaultRunnableSpec.this.fetchAs(targetClass);
            }

            @Override
            public Neo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
                return DefaultRunnableSpec.this.fetch();
            }

            @Override
            public ResultSummary run() {
                return DefaultRunnableSpec.this.run();
            }

            @Override
            public <T> Neo4jClient.OngoingBindSpec<T, Neo4jClient.RunnableSpec> bind(T value) {
                return DefaultRunnableSpec.this.bind(value);
            }

            @Override
            public Neo4jClient.RunnableSpec bindAll(Map<String, Object> parameters) {
                return DefaultRunnableSpec.this.bindAll((Map)parameters);
            }
        }

        class DefaultRunnableSpecBoundToUser
        implements Neo4jClient.RunnableSpecBoundToUser {
            DefaultRunnableSpecBoundToUser() {
            }

            @Override
            public Neo4jClient.RunnableSpecBoundToDatabaseAndUser in(String aDatabase) {
                DefaultRunnableSpec.this.databaseSelection = DefaultNeo4jClient.this.resolveTargetDatabaseName(aDatabase);
                return DefaultRunnableSpec.this;
            }

            @Override
            public <T> Neo4jClient.MappingSpec<T> fetchAs(Class<T> targetClass) {
                return DefaultRunnableSpec.this.fetchAs(targetClass);
            }

            @Override
            public Neo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
                return DefaultRunnableSpec.this.fetch();
            }

            @Override
            public ResultSummary run() {
                return DefaultRunnableSpec.this.run();
            }

            @Override
            public <T> Neo4jClient.OngoingBindSpec<T, Neo4jClient.RunnableSpec> bind(T value) {
                return DefaultRunnableSpec.this.bind(value);
            }

            @Override
            public Neo4jClient.RunnableSpec bindAll(Map<String, Object> parameters) {
                return DefaultRunnableSpec.this.bindAll((Map)parameters);
            }
        }

        class DefaultOngoingBindSpec<T>
        implements Neo4jClient.OngoingBindSpec<T, Neo4jClient.RunnableSpec> {
            @Nullable
            private final T value;

            DefaultOngoingBindSpec(T value) {
                this.value = value;
            }

            @Override
            public Neo4jClient.RunnableSpec to(String name) {
                DefaultRunnableSpec.this.runnableStatement.parameters.add(name, this.value);
                return DefaultRunnableSpec.this;
            }

            @Override
            public Neo4jClient.RunnableSpec with(Function<T, Map<String, Object>> binder) {
                Assert.notNull(binder, (String)"Binder is required");
                return DefaultRunnableSpec.this.bindAll((Map)binder.apply(this.value));
            }
        }
    }

    class DefaultRunnableDelegation<T>
    implements Neo4jClient.RunnableDelegation<T>,
    Neo4jClient.OngoingDelegation<T> {
        private DatabaseSelection databaseSelection;
        @Nullable
        private UserSelection impersonatedUser;
        private final Function<QueryRunner, Optional<T>> callback;

        DefaultRunnableDelegation(Function<QueryRunner, Optional<T>> callback) {
            this.callback = callback;
            this.databaseSelection = DefaultNeo4jClient.this.resolveTargetDatabaseName(null);
            this.impersonatedUser = DefaultNeo4jClient.this.resolveUser(null);
        }

        @Override
        public Neo4jClient.RunnableDelegation<T> in(@Nullable String targetDatabase) {
            this.databaseSelection = DefaultNeo4jClient.this.resolveTargetDatabaseName(targetDatabase);
            return this;
        }

        @Override
        public Optional<T> run() {
            Optional<T> optional;
            block9: {
                QueryRunner queryRunner = DefaultNeo4jClient.this.getQueryRunner(this.databaseSelection, this.impersonatedUser);
                try {
                    optional = this.callback.apply(queryRunner);
                    if (queryRunner == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (queryRunner != null) {
                            try {
                                queryRunner.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                queryRunner.close();
            }
            return optional;
        }
    }

    class DefaultRecordFetchSpec<T>
    implements Neo4jClient.RecordFetchSpec<T>,
    Neo4jClient.MappingSpec<T> {
        private final DatabaseSelection databaseSelection;
        @Nullable
        private final UserSelection impersonatedUser;
        private final RunnableStatement runnableStatement;
        private BiFunction<TypeSystem, Record, T> mappingFunction;

        DefaultRecordFetchSpec(@Nullable DatabaseSelection databaseSelection, UserSelection impersonatedUser, RunnableStatement runnableStatement, BiFunction<TypeSystem, Record, T> mappingFunction) {
            this.databaseSelection = databaseSelection;
            this.impersonatedUser = impersonatedUser;
            this.runnableStatement = runnableStatement;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public Neo4jClient.RecordFetchSpec<T> mappedBy(BiFunction<TypeSystem, Record, T> mappingFunction) {
            this.mappingFunction = mappingFunction;
            return this;
        }

        @Override
        public Optional<T> one() {
            Optional optional;
            block9: {
                QueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.databaseSelection, this.impersonatedUser);
                try {
                    Result result = this.runnableStatement.runWith(statementRunner);
                    Optional optionalValue = result.hasNext() ? Optional.ofNullable(this.mappingFunction.apply(TypeSystem.getDefault(), result.single())) : Optional.empty();
                    ResultSummaries.process(result.consume());
                    optional = optionalValue;
                    if (statementRunner == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (statementRunner != null) {
                            try {
                                statementRunner.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                statementRunner.close();
            }
            return optional;
        }

        @Override
        public Optional<T> first() {
            Optional<Object> optional;
            block9: {
                QueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.databaseSelection, this.impersonatedUser);
                try {
                    Result result = this.runnableStatement.runWith(statementRunner);
                    Optional<Object> optionalValue = result.stream().map(this.partialMappingFunction(TypeSystem.getDefault())).filter(Objects::nonNull).findFirst();
                    ResultSummaries.process(result.consume());
                    optional = optionalValue;
                    if (statementRunner == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (statementRunner != null) {
                            try {
                                statementRunner.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                statementRunner.close();
            }
            return optional;
        }

        @Override
        public Collection<T> all() {
            Collection collection;
            block9: {
                QueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.databaseSelection, this.impersonatedUser);
                try {
                    Result result = this.runnableStatement.runWith(statementRunner);
                    Collection values = result.stream().flatMap(r -> {
                        if (this.mappingFunction instanceof SingleValueMappingFunction && r.size() == 1 && r.get(0).hasType(TypeSystem.getDefault().LIST())) {
                            return r.get(0).asList(v -> ((SingleValueMappingFunction)this.mappingFunction).convertValue((Value)v)).stream();
                        }
                        return Stream.of(this.partialMappingFunction(TypeSystem.getDefault()).apply((Record)r));
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    ResultSummaries.process(result.consume());
                    collection = values;
                    if (statementRunner == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (statementRunner != null) {
                            try {
                                statementRunner.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                statementRunner.close();
            }
            return collection;
        }

        private Function<Record, T> partialMappingFunction(TypeSystem typeSystem) {
            return r -> this.mappingFunction.apply(typeSystem, (Record)r);
        }
    }

    static class RunnableStatement {
        private final Supplier<String> cypherSupplier;
        private final NamedParameters parameters;

        RunnableStatement(Supplier<String> cypherSupplier) {
            this(cypherSupplier, new NamedParameters());
        }

        RunnableStatement(Supplier<String> cypherSupplier, NamedParameters parameters) {
            this.cypherSupplier = cypherSupplier;
            this.parameters = parameters;
        }

        protected final Result runWith(QueryRunner statementRunner) {
            String statementTemplate = this.cypherSupplier.get();
            if (Neo4jClient.cypherLog.isDebugEnabled()) {
                Neo4jClient.cypherLog.debug(() -> String.format("Executing:%s%s", System.lineSeparator(), statementTemplate));
                if (Neo4jClient.cypherLog.isTraceEnabled() && !this.parameters.isEmpty()) {
                    Neo4jClient.cypherLog.trace(() -> String.format("with parameters:%s%s", System.lineSeparator(), this.parameters));
                }
            }
            return statementRunner.run(statementTemplate, this.parameters.get());
        }
    }
}

