/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0")
public final class NestedRelationshipProcessingStateMachine {
    private final StampedLock lock = new StampedLock();
    private final Neo4jMappingContext mappingContext;
    private final Set<RelationshipDescriptionWithSourceId> processedRelationshipDescriptions = new HashSet<RelationshipDescriptionWithSourceId>();
    private final Map<Integer, Object> processedObjectsAlias = new HashMap<Integer, Object>();
    private final Map<Integer, Long> processedObjectsIds = new HashMap<Integer, Long>();

    public NestedRelationshipProcessingStateMachine(Neo4jMappingContext mappingContext) {
        Assert.notNull((Object)mappingContext, (String)"Mapping context is required");
        this.mappingContext = mappingContext;
    }

    public NestedRelationshipProcessingStateMachine(Neo4jMappingContext mappingContext, Object initialObject, Long internalId) {
        this(mappingContext);
        Assert.notNull((Object)initialObject, (String)"Initial object must not be null");
        Assert.notNull((Object)internalId, (String)"The initial objects internal ID must not be null");
        this.storeHashedVersionInProcessedObjectsIds(initialObject, internalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessState getStateOf(Object fromId, RelationshipDescription relationshipDescription, @Nullable Collection<?> valuesToStore) {
        long stamp = this.lock.readLock();
        try {
            boolean hasProcessedRelationship = this.hasProcessedRelationship(fromId, relationshipDescription);
            boolean hasProcessedAllValues = this.hasProcessedAllOf(valuesToStore);
            if (hasProcessedRelationship && hasProcessedAllValues) {
                ProcessState processState = ProcessState.PROCESSED_BOTH;
                return processState;
            }
            if (hasProcessedRelationship) {
                ProcessState processState = ProcessState.PROCESSED_ALL_RELATIONSHIPS;
                return processState;
            }
            if (hasProcessedAllValues) {
                ProcessState processState = ProcessState.PROCESSED_ALL_VALUES;
                return processState;
            }
            ProcessState processState = ProcessState.PROCESSED_NONE;
            return processState;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRelationshipAsProcessed(Object fromId, @Nullable RelationshipDescription relationshipDescription) {
        if (relationshipDescription == null) {
            return;
        }
        long stamp = this.lock.writeLock();
        try {
            this.processedRelationshipDescriptions.add(new RelationshipDescriptionWithSourceId(fromId, relationshipDescription));
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markValueAsProcessed(Object valueToStore, Long internalId) {
        long stamp = this.lock.writeLock();
        try {
            this.doMarkValueAsProcessed(valueToStore, internalId);
            this.storeProcessedInAlias(valueToStore, valueToStore);
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    private void doMarkValueAsProcessed(Object valueToStore, Long internalId) {
        Object value = this.extractRelatedValueFromRelationshipProperties(valueToStore);
        this.storeHashedVersionInProcessedObjectsIds(valueToStore, internalId);
        this.storeHashedVersionInProcessedObjectsIds(value, internalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProcessedValue(Object value) {
        long stamp = this.lock.readLock();
        try {
            Object valueToCheck = this.extractRelatedValueFromRelationshipProperties(value);
            boolean processed = this.hasProcessed(valueToCheck);
            Class<?> typeOfValue = valueToCheck.getClass();
            if (!processed && this.mappingContext.hasPersistentEntityFor(typeOfValue)) {
                Optional alreadyProcessedObject;
                Neo4jPersistentEntity entity = (Neo4jPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeOfValue);
                Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entity.getIdProperty();
                Object id = idProperty == null ? null : entity.getPropertyAccessor(valueToCheck).getProperty((PersistentProperty)idProperty);
                Optional<Object> optional = alreadyProcessedObject = id == null ? Optional.empty() : this.processedObjectsAlias.values().stream().filter(typeOfValue::isInstance).filter(processedObject -> id.equals(entity.getPropertyAccessor(processedObject).getProperty((PersistentProperty)idProperty))).findAny();
                if (alreadyProcessedObject.isPresent()) {
                    processed = true;
                    Long internalId = this.getInternalId(alreadyProcessedObject.get());
                    if (internalId != null) {
                        stamp = this.lock.tryConvertToWriteLock(stamp);
                        this.doMarkValueAsProcessed(valueToCheck, internalId);
                    }
                }
            }
            boolean bl = processed;
            return bl;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProcessedRelationship(Object fromId, @Nullable RelationshipDescription relationshipDescription) {
        if (relationshipDescription != null) {
            long stamp = this.lock.readLock();
            try {
                boolean bl = this.processedRelationshipDescriptions.contains(new RelationshipDescriptionWithSourceId(fromId, relationshipDescription));
                return bl;
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markValueAsProcessedAs(Object valueToStore, Object bean) {
        long stamp = this.lock.writeLock();
        try {
            this.storeProcessedInAlias(valueToStore, bean);
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Long getInternalId(Object object) {
        long stamp = this.lock.readLock();
        try {
            Object valueToCheck = this.extractRelatedValueFromRelationshipProperties(object);
            Long possibleId = this.getProcessedObjectIds(valueToCheck);
            Long l = possibleId != null ? possibleId : this.getProcessedObjectIds(this.getProcessedAs(valueToCheck));
            return l;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProcessedAs(Object entity) {
        long stamp = this.lock.readLock();
        try {
            Object object = this.getProcessedAsWithDefaults(entity);
            return object;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    @Nullable
    private Long getProcessedObjectIds(@Nullable Object entity) {
        if (entity == null) {
            return null;
        }
        return this.processedObjectsIds.get(System.identityHashCode(entity));
    }

    @NonNull
    private Object extractRelatedValueFromRelationshipProperties(Object valueToStore) {
        Object value = valueToStore instanceof MappingSupport.RelationshipPropertiesWithEntityHolder ? ((MappingSupport.RelationshipPropertiesWithEntityHolder)valueToStore).getRelatedEntity() : valueToStore;
        return value;
    }

    private void storeHashedVersionInProcessedObjectsIds(Object initialObject, Long internalId) {
        this.processedObjectsIds.put(System.identityHashCode(initialObject), internalId);
    }

    private void storeProcessedInAlias(Object valueToStore, Object bean) {
        this.processedObjectsAlias.put(System.identityHashCode(valueToStore), bean);
    }

    private Object getProcessedAsWithDefaults(Object entity) {
        return this.processedObjectsAlias.getOrDefault(System.identityHashCode(entity), entity);
    }

    private boolean hasProcessed(Object valueToCheck) {
        return this.processedObjectsAlias.containsKey(System.identityHashCode(valueToCheck));
    }

    private boolean hasProcessedAllOf(@Nullable Collection<?> valuesToStore) {
        if (valuesToStore == null) {
            return false;
        }
        return this.processedObjectsIds.keySet().containsAll(valuesToStore.stream().map(System::identityHashCode).collect(Collectors.toList()));
    }

    public static enum ProcessState {
        PROCESSED_NONE,
        PROCESSED_BOTH,
        PROCESSED_ALL_RELATIONSHIPS,
        PROCESSED_ALL_VALUES;

    }

    private static class RelationshipDescriptionWithSourceId {
        private final Object id;
        private final RelationshipDescription relationshipDescription;

        RelationshipDescriptionWithSourceId(Object id, RelationshipDescription relationshipDescription) {
            this.id = id;
            this.relationshipDescription = relationshipDescription;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelationshipDescriptionWithSourceId that = (RelationshipDescriptionWithSourceId)o;
            return this.id.equals(that.id) && this.relationshipDescription.equals(that.relationshipDescription);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.relationshipDescription);
        }
    }
}

