/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.convert;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.neo4j.core.convert.ConvertWith;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverterFactory;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

final class DefaultNeo4jPersistentPropertyConverterFactory
implements Neo4jPersistentPropertyConverterFactory {
    @Nullable
    private final BeanFactory beanFactory;

    DefaultNeo4jPersistentPropertyConverterFactory(@Nullable BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Neo4jPersistentPropertyConverter<?> getPropertyConverterFor(Neo4jPersistentProperty persistentProperty) {
        ConvertWith config = (ConvertWith)persistentProperty.getRequiredAnnotation(ConvertWith.class);
        if (StringUtils.hasText((String)config.converterRef())) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("The default converter factory has been configured without a bean factory and cannot use a converter from the application context.");
            }
            return (Neo4jPersistentPropertyConverter)this.beanFactory.getBean(config.converterRef(), Neo4jPersistentPropertyConverter.class);
        }
        if (config.converter() == ConvertWith.UnsetConverter.class) {
            throw new IllegalArgumentException("The default custom conversion factory cannot be used with a placeholder");
        }
        return (Neo4jPersistentPropertyConverter)BeanUtils.instantiateClass(config.converter());
    }
}

