/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.neo4j.repository.support.Neo4jEntityInformation;
import org.springframework.data.repository.reactive.ReactiveSortingRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Repository
@Transactional(readOnly=true)
@API(status=API.Status.STABLE, since="6.0")
public class SimpleReactiveNeo4jRepository<T, ID>
implements ReactiveSortingRepository<T, ID> {
    private final ReactiveNeo4jOperations neo4jOperations;
    private final Neo4jEntityInformation<T, ID> entityInformation;
    private final Neo4jPersistentEntity<T> entityMetaData;

    protected SimpleReactiveNeo4jRepository(ReactiveNeo4jOperations neo4jOperations, Neo4jEntityInformation<T, ID> entityInformation) {
        this.neo4jOperations = neo4jOperations;
        this.entityInformation = entityInformation;
        this.entityMetaData = this.entityInformation.getEntityMetaData();
    }

    public Mono<T> findById(ID id) {
        return this.neo4jOperations.findById(id, this.entityInformation.getJavaType());
    }

    public Mono<T> findById(Publisher<ID> idPublisher) {
        return Mono.from(idPublisher).flatMap(this::findById);
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        return this.neo4jOperations.findAllById(ids, this.entityInformation.getJavaType());
    }

    public Flux<T> findAllById(Publisher<ID> idStream) {
        return Flux.from(idStream).buffer().flatMap(this::findAllById);
    }

    public Flux<T> findAll() {
        return this.neo4jOperations.findAll(this.entityInformation.getJavaType());
    }

    public Flux<T> findAll(Sort sort) {
        return this.neo4jOperations.toExecutableQuery(this.entityInformation.getJavaType(), QueryFragmentsAndParameters.forPageableAndSort(this.entityMetaData, null, sort)).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    public Mono<Long> count() {
        return this.neo4jOperations.count(this.entityInformation.getJavaType());
    }

    public Mono<Boolean> existsById(ID id) {
        return this.findById(id).hasElement();
    }

    public Mono<Boolean> existsById(Publisher<ID> idPublisher) {
        return Mono.from(idPublisher).flatMap(this::existsById);
    }

    @Transactional
    public <S extends T> Mono<S> save(S entity) {
        return this.neo4jOperations.save(entity);
    }

    @Transactional
    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        return this.neo4jOperations.saveAll(entities);
    }

    @Transactional
    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        return Flux.from(entityStream).flatMap(this::save);
    }

    @Transactional
    public Mono<Void> deleteById(ID id) {
        return this.neo4jOperations.deleteById(id, this.entityInformation.getJavaType());
    }

    @Transactional
    public Mono<Void> deleteById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"The given Publisher of an id must not be null!");
        return Mono.from(idPublisher).flatMap(this::deleteById);
    }

    @Transactional
    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null!");
        Object id = this.entityInformation.getId(entity);
        if (this.entityMetaData.hasVersionProperty()) {
            Neo4jPersistentProperty versionProperty = (Neo4jPersistentProperty)this.entityMetaData.getRequiredVersionProperty();
            Object versionValue = this.entityMetaData.getPropertyAccessor(entity).getProperty((PersistentProperty)versionProperty);
            return this.neo4jOperations.deleteByIdWithVersion(id, this.entityInformation.getJavaType(), versionProperty, versionValue);
        }
        return this.deleteById(id);
    }

    @Transactional
    public Mono<Void> deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null!");
        return this.neo4jOperations.deleteAllById(ids, this.entityInformation.getJavaType());
    }

    @Transactional
    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        List ids = StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> this.entityInformation.getId(arg_0)).collect(Collectors.toList());
        return this.neo4jOperations.deleteAllById(ids, this.entityInformation.getJavaType());
    }

    @Transactional
    public Mono<Void> deleteAll(Publisher<? extends T> entitiesPublisher) {
        Assert.notNull(entitiesPublisher, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entitiesPublisher).flatMap(this::delete).then();
    }

    @Transactional
    public Mono<Void> deleteAll() {
        return this.neo4jOperations.deleteAll(this.entityInformation.getJavaType());
    }
}

