/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import java.util.Collection;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactive.RxTransaction;
import org.reactivestreams.Publisher;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionContext;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionUtils;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolderSupport;
import reactor.core.publisher.Mono;

final class ReactiveNeo4jTransactionHolder
extends ResourceHolderSupport {
    private final Neo4jTransactionContext context;
    private final RxSession session;
    private final RxTransaction transaction;

    ReactiveNeo4jTransactionHolder(Neo4jTransactionContext context, RxSession session, RxTransaction transaction) {
        this.context = context;
        this.session = session;
        this.transaction = transaction;
    }

    RxSession getSession() {
        return this.session;
    }

    @Nullable
    RxTransaction getTransaction(String inDatabase) {
        return Neo4jTransactionUtils.namesMapToTheSameDatabase(this.context.getDatabaseName(), inDatabase) ? this.transaction : null;
    }

    Mono<Bookmark> commit() {
        return Mono.from((Publisher)this.transaction.commit()).then(Mono.fromSupplier(() -> this.session.lastBookmark()));
    }

    Mono<Void> rollback() {
        return Mono.from((Publisher)this.transaction.rollback());
    }

    Mono<Void> close() {
        return Mono.from((Publisher)this.session.close());
    }

    String getDatabaseName() {
        return this.context.getDatabaseName();
    }

    Collection<Bookmark> getBookmarks() {
        return this.context.getBookmarks();
    }
}

