/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apiguardian.api.API;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;

@API(status=API.Status.INTERNAL, since="6.1.3")
public final class PropertyFilterSupport {
    public static Map<PropertyPath, Boolean> getInputProperties(ResultProcessor resultProcessor, ProjectionFactory factory, Neo4jMappingContext mappingContext) {
        ReturnedType returnedType = resultProcessor.getReturnedType();
        HashMap<PropertyPath, Boolean> filteredProperties = new HashMap<PropertyPath, Boolean>();
        boolean isProjecting = returnedType.isProjecting();
        boolean isClosedProjection = factory.getProjectionInformation(returnedType.getReturnedType()).isClosed();
        if (!isProjecting || !isClosedProjection) {
            return Collections.emptyMap();
        }
        for (String inputProperty : returnedType.getInputProperties()) {
            PropertyFilterSupport.addPropertiesFrom(returnedType.getDomainType(), returnedType.getReturnedType(), factory, filteredProperties, inputProperty, mappingContext);
        }
        return filteredProperties;
    }

    static Map<PropertyPath, Boolean> addPropertiesFrom(Class<?> domainType, Class<?> returnType, ProjectionFactory projectionFactory, Neo4jMappingContext neo4jMappingContext) {
        ProjectionInformation projectionInformation = projectionFactory.getProjectionInformation(returnType);
        HashMap<PropertyPath, Boolean> propertyPaths = new HashMap<PropertyPath, Boolean>();
        for (PropertyDescriptor inputProperty : projectionInformation.getInputProperties()) {
            PropertyFilterSupport.addPropertiesFrom(domainType, returnType, projectionFactory, propertyPaths, inputProperty.getName(), neo4jMappingContext);
        }
        return propertyPaths;
    }

    private static void addPropertiesFrom(Class<?> domainType, Class<?> returnedType, ProjectionFactory factory, Map<PropertyPath, Boolean> filteredProperties, String inputProperty, Neo4jMappingContext mappingContext) {
        ProjectionInformation projectionInformation = factory.getProjectionInformation(returnedType);
        PropertyPath propertyPath = projectionInformation.isClosed() ? PropertyPath.from((String)inputProperty, returnedType) : PropertyPath.from((String)inputProperty, domainType);
        Class propertyType = propertyPath.getLeafType();
        if (mappingContext.getConversionService().isSimpleType(propertyType)) {
            filteredProperties.put(propertyPath, false);
        } else if (mappingContext.hasPersistentEntityFor(propertyType)) {
            PropertyFilterSupport.addPropertiesFromEntity(filteredProperties, propertyPath, propertyType, mappingContext, new HashSet());
        } else {
            ProjectionInformation nestedProjectionInformation = factory.getProjectionInformation(propertyType);
            if (nestedProjectionInformation.isClosed()) {
                filteredProperties.put(propertyPath, false);
                for (PropertyDescriptor nestedInputProperty : nestedProjectionInformation.getInputProperties()) {
                    PropertyPath nestedPropertyPath = propertyPath.nested(nestedInputProperty.getName());
                    if (!propertyPath.hasNext() || !domainType.equals(propertyPath.getLeafProperty().getOwningType().getType()) && !returnedType.equals(propertyPath.getLeafProperty().getOwningType().getType())) {
                        PropertyFilterSupport.addPropertiesFrom(domainType, returnedType, factory, filteredProperties, nestedPropertyPath.toDotPath(), mappingContext);
                        continue;
                    }
                    break;
                }
            } else {
                filteredProperties.put(propertyPath, true);
                PropertyFilterSupport.processEntity(domainType, filteredProperties, inputProperty, mappingContext);
            }
        }
    }

    private static void processEntity(Class<?> domainType, Map<PropertyPath, Boolean> filteredProperties, String inputProperty, Neo4jMappingContext mappingContext) {
        Neo4jPersistentEntity persistentEntity = (Neo4jPersistentEntity)mappingContext.getPersistentEntity(domainType);
        Neo4jPersistentProperty persistentProperty = (Neo4jPersistentProperty)persistentEntity.getPersistentProperty(inputProperty);
        Class propertyEntityType = persistentProperty.getActualType();
        PropertyPath propertyPath = PropertyPath.from((String)inputProperty, domainType);
        PropertyFilterSupport.addPropertiesFromEntity(filteredProperties, propertyPath, propertyEntityType, mappingContext, new HashSet());
    }

    private static void addPropertiesFromEntity(Map<PropertyPath, Boolean> filteredProperties, PropertyPath propertyPath, Class<?> propertyType, Neo4jMappingContext mappingContext, Collection<Neo4jPersistentEntity<?>> processedEntities) {
        if (!mappingContext.hasPersistentEntityFor(propertyType)) {
            throw new RuntimeException("hmmmm");
        }
        Neo4jPersistentEntity persistentEntityFromProperty = (Neo4jPersistentEntity)mappingContext.getPersistentEntity(propertyType);
        if (PropertyFilterSupport.hasProcessedEntity(persistentEntityFromProperty, processedEntities)) {
            return;
        }
        filteredProperties.put(propertyPath, true);
    }

    private static boolean hasProcessedEntity(Neo4jPersistentEntity<?> persistentEntityFromProperty, Collection<Neo4jPersistentEntity<?>> processedEntities) {
        return processedEntities.contains(persistentEntityFromProperty);
    }
}

