/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import org.apiguardian.api.API;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactive.RxTransaction;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.data.neo4j.core.transaction.Neo4jBookmarkManager;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionContext;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionUtils;
import org.springframework.data.neo4j.core.transaction.ReactiveNeo4jSessionSynchronization;
import org.springframework.data.neo4j.core.transaction.ReactiveNeo4jTransactionHolder;
import org.springframework.lang.Nullable;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.reactive.AbstractReactiveTransactionManager;
import org.springframework.transaction.reactive.GenericReactiveTransaction;
import org.springframework.transaction.reactive.TransactionSynchronization;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

@API(status=API.Status.STABLE, since="6.0")
public final class ReactiveNeo4jTransactionManager
extends AbstractReactiveTransactionManager
implements ApplicationContextAware {
    private final Driver driver;
    private final ReactiveDatabaseSelectionProvider databaseSelectionProvider;
    private final Neo4jBookmarkManager bookmarkManager;

    public ReactiveNeo4jTransactionManager(Driver driver) {
        this(driver, ReactiveDatabaseSelectionProvider.getDefaultSelectionProvider());
    }

    public ReactiveNeo4jTransactionManager(Driver driver, ReactiveDatabaseSelectionProvider databaseSelectionProvider) {
        this(driver, databaseSelectionProvider, Neo4jBookmarkManager.create());
    }

    public ReactiveNeo4jTransactionManager(Driver driver, ReactiveDatabaseSelectionProvider databaseSelectionProvider, Neo4jBookmarkManager bookmarkManager) {
        this.driver = driver;
        this.databaseSelectionProvider = databaseSelectionProvider;
        this.bookmarkManager = bookmarkManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.bookmarkManager.setApplicationEventPublisher((ApplicationEventPublisher)applicationContext);
    }

    public static Mono<RxTransaction> retrieveReactiveTransaction(Driver driver, String targetDatabase) {
        return TransactionSynchronizationManager.forCurrentTransaction().filter(TransactionSynchronizationManager::isSynchronizationActive).flatMap(tsm -> {
            ReactiveNeo4jTransactionHolder existingTxHolder = (ReactiveNeo4jTransactionHolder)((Object)((Object)tsm.getResource((Object)driver)));
            if (existingTxHolder != null) {
                return Mono.just((Object)((Object)existingTxHolder));
            }
            return Mono.defer(() -> {
                RxSession session = driver.rxSession(Neo4jTransactionUtils.defaultSessionConfig(targetDatabase));
                return Mono.from((Publisher)session.beginTransaction(TransactionConfig.empty())).map(tx -> {
                    ReactiveNeo4jTransactionHolder newConnectionHolder = new ReactiveNeo4jTransactionHolder(new Neo4jTransactionContext(targetDatabase), session, (RxTransaction)tx);
                    newConnectionHolder.setSynchronizedWithTransaction(true);
                    tsm.registerSynchronization((TransactionSynchronization)new ReactiveNeo4jSessionSynchronization((TransactionSynchronizationManager)tsm, newConnectionHolder, driver));
                    tsm.bindResource((Object)driver, (Object)newConnectionHolder);
                    return newConnectionHolder;
                });
            });
        }).map(connectionHolder -> {
            RxTransaction transaction = connectionHolder.getTransaction(targetDatabase);
            if (transaction == null) {
                throw new IllegalStateException(Neo4jTransactionUtils.formatOngoingTxInAnotherDbErrorMessage(connectionHolder.getDatabaseName(), targetDatabase));
            }
            return transaction;
        }).onErrorResume(NoTransactionException.class, nte -> Mono.empty());
    }

    private static ReactiveNeo4jTransactionObject extractNeo4jTransaction(Object transaction) {
        Assert.isInstanceOf(ReactiveNeo4jTransactionObject.class, (Object)transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", ReactiveNeo4jTransactionObject.class, transaction.getClass()));
        return (ReactiveNeo4jTransactionObject)transaction;
    }

    private static ReactiveNeo4jTransactionObject extractNeo4jTransaction(GenericReactiveTransaction status) {
        return ReactiveNeo4jTransactionManager.extractNeo4jTransaction(status.getTransaction());
    }

    protected Object doGetTransaction(TransactionSynchronizationManager transactionSynchronizationManager) throws TransactionException {
        ReactiveNeo4jTransactionHolder resourceHolder = (ReactiveNeo4jTransactionHolder)((Object)transactionSynchronizationManager.getResource((Object)this.driver));
        return new ReactiveNeo4jTransactionObject(resourceHolder);
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return ReactiveNeo4jTransactionManager.extractNeo4jTransaction(transaction).hasResourceHolder();
    }

    protected Mono<Void> doBegin(TransactionSynchronizationManager transactionSynchronizationManager, Object transaction, TransactionDefinition transactionDefinition) throws TransactionException {
        return Mono.defer(() -> {
            ReactiveNeo4jTransactionObject transactionObject = ReactiveNeo4jTransactionManager.extractNeo4jTransaction(transaction);
            TransactionConfig transactionConfig = Neo4jTransactionUtils.createTransactionConfigFrom(transactionDefinition);
            boolean readOnly = transactionDefinition.isReadOnly();
            transactionSynchronizationManager.setCurrentTransactionReadOnly(readOnly);
            return this.databaseSelectionProvider.getDatabaseSelection().switchIfEmpty(Mono.just((Object)DatabaseSelection.undecided())).map(databaseName -> new Neo4jTransactionContext(databaseName.getValue(), this.bookmarkManager.getBookmarks())).map(context -> Tuples.of((Object)context, (Object)this.driver.rxSession(Neo4jTransactionUtils.sessionConfig(readOnly, context.getBookmarks(), context.getDatabaseName())))).flatMap(contextAndSession -> Mono.from((Publisher)((RxSession)contextAndSession.getT2()).beginTransaction(transactionConfig)).map(nativeTransaction -> new ReactiveNeo4jTransactionHolder((Neo4jTransactionContext)contextAndSession.getT1(), (RxSession)contextAndSession.getT2(), (RxTransaction)nativeTransaction))).doOnNext(transactionHolder -> {
                transactionHolder.setSynchronizedWithTransaction(true);
                transactionObject.setResourceHolder((ReactiveNeo4jTransactionHolder)((Object)((Object)transactionHolder)));
                transactionSynchronizationManager.bindResource((Object)this.driver, (Object)transactionHolder);
            });
        }).then();
    }

    protected Mono<Void> doCleanupAfterCompletion(TransactionSynchronizationManager transactionSynchronizationManager, Object transaction) {
        return Mono.just((Object)ReactiveNeo4jTransactionManager.extractNeo4jTransaction(transaction)).map(r -> {
            ReactiveNeo4jTransactionHolder holder = r.getRequiredResourceHolder();
            r.setResourceHolder(null);
            return holder;
        }).flatMap(ReactiveNeo4jTransactionHolder::close).then(Mono.fromRunnable(() -> transactionSynchronizationManager.unbindResource((Object)this.driver)));
    }

    protected Mono<Void> doCommit(TransactionSynchronizationManager transactionSynchronizationManager, GenericReactiveTransaction genericReactiveTransaction) throws TransactionException {
        ReactiveNeo4jTransactionHolder holder = ReactiveNeo4jTransactionManager.extractNeo4jTransaction(genericReactiveTransaction).getRequiredResourceHolder();
        return holder.commit().doOnNext(bookmark -> this.bookmarkManager.updateBookmarks(holder.getBookmarks(), (Bookmark)bookmark)).then();
    }

    protected Mono<Void> doRollback(TransactionSynchronizationManager transactionSynchronizationManager, GenericReactiveTransaction genericReactiveTransaction) throws TransactionException {
        ReactiveNeo4jTransactionHolder holder = ReactiveNeo4jTransactionManager.extractNeo4jTransaction(genericReactiveTransaction).getRequiredResourceHolder();
        return holder.rollback();
    }

    protected Mono<Object> doSuspend(TransactionSynchronizationManager synchronizationManager, Object transaction) throws TransactionException {
        return Mono.just((Object)ReactiveNeo4jTransactionManager.extractNeo4jTransaction(transaction)).doOnNext(r -> r.setResourceHolder(null)).then(Mono.fromSupplier(() -> synchronizationManager.unbindResource((Object)this.driver)));
    }

    protected Mono<Void> doResume(TransactionSynchronizationManager synchronizationManager, Object transaction, Object suspendedResources) throws TransactionException {
        return Mono.just((Object)ReactiveNeo4jTransactionManager.extractNeo4jTransaction(transaction)).doOnNext(r -> r.setResourceHolder((ReactiveNeo4jTransactionHolder)((Object)((Object)suspendedResources)))).then(Mono.fromRunnable(() -> synchronizationManager.bindResource((Object)this.driver, suspendedResources)));
    }

    protected Mono<Void> doSetRollbackOnly(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction genericReactiveTransaction) throws TransactionException {
        return Mono.fromRunnable(() -> {
            ReactiveNeo4jTransactionObject transactionObject = ReactiveNeo4jTransactionManager.extractNeo4jTransaction(genericReactiveTransaction);
            transactionObject.getRequiredResourceHolder().setRollbackOnly();
        });
    }

    static class ReactiveNeo4jTransactionObject
    implements SmartTransactionObject {
        private static final String RESOURCE_HOLDER_NOT_PRESENT_MESSAGE = "Neo4jConnectionHolder is required but not present. o_O";
        @Nullable
        private ReactiveNeo4jTransactionHolder resourceHolder;

        ReactiveNeo4jTransactionObject(@Nullable ReactiveNeo4jTransactionHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        void setResourceHolder(@Nullable ReactiveNeo4jTransactionHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        boolean hasResourceHolder() {
            return this.resourceHolder != null;
        }

        ReactiveNeo4jTransactionHolder getRequiredResourceHolder() {
            Assert.state((boolean)this.hasResourceHolder(), (String)RESOURCE_HOLDER_NOT_PRESENT_MESSAGE);
            return this.resourceHolder;
        }

        void setRollbackOnly() {
            this.getRequiredResourceHolder().setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.hasResourceHolder() && this.resourceHolder.isRollbackOnly();
        }

        public void flush() {
            TransactionSynchronizationUtils.triggerFlush();
        }
    }
}

