/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.mapping.NodeDescription;

@API(status=API.Status.INTERNAL)
public abstract class PropertyFilter {
    public static PropertyFilter from(Collection<PropertyPath> properties, NodeDescription<?> nodeDescription) {
        return new FilteringPropertyFilter(properties, nodeDescription);
    }

    public static PropertyFilter acceptAll() {
        return new NonFilteringPropertyFilter();
    }

    public abstract boolean contains(String var1, Class<?> var2);

    public abstract boolean contains(RelaxedPropertyPath var1);

    public abstract boolean isNotFiltering();

    public static class RelaxedPropertyPath {
        private final String dotPath;
        private final Class<?> type;

        public static RelaxedPropertyPath withRootType(Class<?> type) {
            return new RelaxedPropertyPath("", type);
        }

        public String toDotPath() {
            return this.dotPath;
        }

        public Class<?> getType() {
            return this.type;
        }

        private RelaxedPropertyPath(String dotPath, Class<?> type) {
            this.dotPath = dotPath;
            this.type = type;
        }

        public RelaxedPropertyPath append(String pathPart) {
            return new RelaxedPropertyPath(this.appendToDotPath(pathPart), this.getType());
        }

        private String appendToDotPath(String pathPart) {
            return this.dotPath.isEmpty() ? pathPart : this.dotPath + "." + pathPart;
        }
    }

    private static class NonFilteringPropertyFilter
    extends PropertyFilter {
        private NonFilteringPropertyFilter() {
        }

        @Override
        public boolean contains(String dotPath, Class<?> typeToCheck) {
            return true;
        }

        @Override
        public boolean contains(RelaxedPropertyPath propertyPath) {
            return true;
        }

        @Override
        public boolean isNotFiltering() {
            return true;
        }
    }

    private static class FilteringPropertyFilter
    extends PropertyFilter {
        private final Set<Class<?>> rootClasses;
        private final Set<String> projectingPropertyPaths;

        private FilteringPropertyFilter(Collection<PropertyPath> properties, NodeDescription<?> nodeDescription) {
            Class<?> domainClass = nodeDescription.getUnderlyingClass();
            this.rootClasses = new HashSet();
            this.rootClasses.add(domainClass);
            properties.stream().map(property -> property.getOwningType().getType()).forEach(this.rootClasses::add);
            nodeDescription.getChildNodeDescriptionsInHierarchy().stream().map(NodeDescription::getUnderlyingClass).forEach(this.rootClasses::add);
            this.projectingPropertyPaths = properties.stream().map(PropertyPath::toDotPath).collect(Collectors.toSet());
        }

        @Override
        public boolean contains(String dotPath, Class<?> typeToCheck) {
            if (this.isNotFiltering()) {
                return true;
            }
            if (!this.rootClasses.contains(typeToCheck)) {
                return false;
            }
            return this.projectingPropertyPaths.contains(dotPath);
        }

        @Override
        public boolean contains(RelaxedPropertyPath propertyPath) {
            return this.contains(propertyPath.toDotPath(), propertyPath.getType());
        }

        @Override
        public boolean isNotFiltering() {
            return this.projectingPropertyPaths.isEmpty();
        }
    }
}

