/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.io.Serializable;
import org.neo4j.ogm.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.support.Neo4jRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.util.Assert;

public class Neo4jRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID> {
    private Session session;
    private Neo4jMappingContext mappingContext;

    public Neo4jRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    @Autowired
    public void setSession(Session session) {
        this.session = session;
    }

    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        if (mappingContext instanceof Neo4jMappingContext) {
            this.mappingContext = (Neo4jMappingContext)mappingContext;
        }
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.session, (String)"Session must not be null!");
        super.afterPropertiesSet();
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        return this.createRepositoryFactory(this.session);
    }

    @Deprecated
    protected RepositoryFactorySupport createRepositoryFactory(Session session) {
        return new Neo4jRepositoryFactory(session, (MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty>)this.mappingContext);
    }
}

