/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Optional;
import org.neo4j.ogm.context.SingleUseEntityMapper;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.EntityFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.neo4j.annotation.QueryResult;
import org.springframework.data.neo4j.repository.query.QueryResultProxy;
import org.springframework.lang.Nullable;

class CustomResultConverter
implements Converter<Object, Object> {
    private final MetaData metaData;
    private final Class returnedType;
    private final Optional<Constructor<?>> singleUseEntityMapperUsingInstantiator;
    private final Object entityInstantiator;

    CustomResultConverter(MetaData metaData, Class<?> returnedType, Optional<Constructor<?>> singleUseEntityMapperUsingInstantiator, @Nullable Object entityInstantiator) {
        this.metaData = metaData;
        this.returnedType = returnedType;
        this.singleUseEntityMapperUsingInstantiator = singleUseEntityMapperUsingInstantiator;
        this.entityInstantiator = entityInstantiator;
    }

    public Object convert(Object source) {
        if (this.returnedType.getAnnotation(QueryResult.class) == null) {
            return source;
        }
        if (this.returnedType.isInterface()) {
            Class[] interfaces = new Class[]{this.returnedType};
            return Proxy.newProxyInstance(this.returnedType.getClassLoader(), interfaces, (InvocationHandler)new QueryResultProxy((Map)source));
        }
        SingleUseEntityMapper mapper = this.singleUseEntityMapperUsingInstantiator.map(constructor -> (SingleUseEntityMapper)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{this.metaData, this.entityInstantiator})).orElseGet(() -> new SingleUseEntityMapper(this.metaData, new EntityFactory(this.metaData)));
        return mapper.map(this.returnedType, (Map)source);
    }
}

