/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived.builder;

import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.Filter;
import org.springframework.data.repository.query.parser.Part;

public abstract class FilterBuilder {
    protected Part part;
    protected BooleanOperator booleanOperator;
    protected Class<?> entityType;

    FilterBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        this.part = part;
        this.booleanOperator = booleanOperator;
        this.entityType = entityType;
    }

    public abstract List<Filter> build(Stack<Object> var1);

    boolean isNegated() {
        return this.part.getType().name().startsWith("NOT");
    }

    protected String propertyName() {
        return this.part.getProperty().getSegment();
    }

    void setNestedAttributes(Part part, Filter filter) {
        if (part.getProperty().next() != null) {
            filter.setOwnerEntityType(part.getProperty().getOwningType().getType());
            filter.setNestedPropertyType(part.getProperty().getType());
            filter.setPropertyName(part.getProperty().getLeafProperty().getSegment());
            filter.setNestedPropertyName(part.getProperty().getSegment());
        }
    }
}

