/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.util.Collection;
import java.util.Map;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.result.QueryStatistics;
import org.neo4j.ogm.session.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.neo4j.event.AfterDeleteEvent;
import org.springframework.data.neo4j.event.AfterSaveEvent;
import org.springframework.data.neo4j.event.BeforeDeleteEvent;
import org.springframework.data.neo4j.event.BeforeSaveEvent;
import org.springframework.data.neo4j.event.Neo4jDataManipulationEvent;
import org.springframework.data.neo4j.template.Neo4jOgmExceptionTranslator;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.data.neo4j.util.IterableUtils;
import org.springframework.util.Assert;

public class Neo4jTemplate
implements Neo4jOperations,
ApplicationEventPublisherAware {
    private final Session session;
    private ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public Neo4jTemplate(Session session) {
        Assert.notNull((Object)session, (String)"Cannot create a Neo4jTemplate without a Session!");
        this.session = session;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public <T> T load(Class<T> type, Long id) {
        try {
            return (T)this.session.load(type, id);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> T load(Class<T> type, Long id, int depth) {
        try {
            return (T)this.session.load(type, id, depth);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids) {
        try {
            return this.session.loadAll(type, ids);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, int depth) {
        try {
            return this.session.loadAll(type, ids, depth);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type) {
        try {
            return this.session.loadAll(type);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, int depth) {
        try {
            return this.session.loadAll(type, depth);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    public <T> Collection<T> loadAll(Collection<T> objects) {
        try {
            return this.session.loadAll(objects);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, int depth) {
        try {
            return this.session.loadAll(objects, depth);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> T loadByProperty(Class<T> type, String propertyName, Object propertyValue) {
        try {
            return IterableUtils.getSingle(this.loadAllByProperty(type, propertyName, propertyValue));
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    public <T> T loadByPropertyOrNull(Class<T> type, String propertyName, Object propertyValue) {
        try {
            return IterableUtils.getSingleOrNull(this.loadAllByProperty(type, propertyName, propertyValue));
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> Collection<T> loadAllByProperty(Class<T> type, String name, Object value) {
        try {
            return this.session.loadAll(type, new Filter(name, value));
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> T loadByProperties(Class<T> type, Filters parameters) {
        try {
            return IterableUtils.getSingle(this.loadAllByProperties(type, parameters));
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> Collection<T> loadAllByProperties(Class<T> type, Filters parameters) {
        try {
            return this.session.loadAll(type, parameters);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    public <T> Collection<T> loadAllByProperty(Class<T> type, String name, Object value, int depth) {
        try {
            return this.session.loadAll(type, new Filter(name, value), depth);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public void delete(Object entity) {
        try {
            this.publishEvent(new BeforeDeleteEvent(this, entity));
            this.session.delete(entity);
            this.publishEvent(new AfterDeleteEvent(this, entity));
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    public <T> void deleteAll(Class<T> type) {
        try {
            this.session.deleteAll(type);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public QueryStatistics execute(String jsonStatements) {
        try {
            return this.session.execute(jsonStatements);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public QueryStatistics execute(String cypher, Map<String, Object> parameters) {
        try {
            return this.session.execute(cypher, parameters);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    public void purgeSession() {
        try {
            this.session.clear();
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> T save(T entity) {
        try {
            this.publishEvent(new BeforeSaveEvent(this, entity));
            this.session.save(entity);
            this.publishEvent(new AfterSaveEvent(this, entity));
            return entity;
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    public <T> T save(T entity, int depth) {
        try {
            this.publishEvent(new BeforeSaveEvent(this, entity));
            this.session.save(entity, depth);
            this.publishEvent(new AfterSaveEvent(this, entity));
            return entity;
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters) {
        try {
            return this.session.query(cypher, parameters);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> Iterable<T> queryForObjects(Class<T> objectType, String cypher, Map<String, ?> parameters) {
        try {
            return this.session.query(objectType, cypher, parameters);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters, boolean readOnly) {
        try {
            return this.session.query(cypher, parameters, readOnly);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> T queryForObject(Class<T> objectType, String cypher, Map<String, ?> parameters) {
        try {
            return (T)this.session.queryForObject(objectType, cypher, parameters);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    @Override
    public long count(Class<?> entityClass) {
        try {
            return this.session.countEntitiesOfType(entityClass);
        }
        catch (Exception e) {
            throw Neo4jOgmExceptionTranslator.translateExceptionIfPossible(e);
        }
    }

    private void publishEvent(Neo4jDataManipulationEvent event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
    }
}

