/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class RelationshipNodeFieldAccessorFactory
implements FieldAccessorFactory {
    private Neo4jTemplate template;

    public RelationshipNodeFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty f) {
        return this.isStartNodeField(f) || this.isEndNodeField(f);
    }

    private boolean isEndNodeField(Neo4jPersistentProperty f) {
        return f.isEndNode();
    }

    private boolean isStartNodeField(Neo4jPersistentProperty f) {
        return f.isStartNode();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        if (this.isStartNodeField(property)) {
            return new RelationshipNodeFieldAccessor(property, this.template){

                @Override
                protected Node getNode(Relationship relationship) {
                    return relationship.getStartNode();
                }
            };
        }
        if (this.isEndNodeField(property)) {
            return new RelationshipNodeFieldAccessor(property, this.template){

                @Override
                protected Node getNode(Relationship relationship) {
                    return relationship.getEndNode();
                }
            };
        }
        return null;
    }

    public static abstract class RelationshipNodeFieldAccessor
    implements FieldAccessor {
        private final Neo4jPersistentProperty property;
        private final Neo4jTemplate template;

        public RelationshipNodeFieldAccessor(Neo4jPersistentProperty property, Neo4jTemplate template) {
            this.property = property;
            this.template = template;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            throw new InvalidDataAccessApiUsageException("Cannot change start or end node of existing relationship.");
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            Relationship relationship = (Relationship)this.template.getPersistentState(entity);
            Node node = this.getNode(relationship);
            if (node == null) {
                return null;
            }
            Object result = this.template.createEntityFromState(node, this.property.getType(), mappingPolicy);
            return DoReturn.doReturn(result);
        }

        protected abstract Node getNode(Relationship var1);

        @Override
        public boolean isWriteable(Object entity) {
            return false;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

