/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.neo4j.fieldaccess.DynamicProperties;

public class DynamicPropertiesContainer
implements DynamicProperties {
    private final Map<String, Object> map = new HashMap<String, Object>();
    private boolean dirty;

    public DynamicPropertiesContainer() {
    }

    public DynamicPropertiesContainer(Map<String, Object> map) {
        this.map.putAll(map);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public Object getProperty(String key) {
        return this.map.get(key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (!this.hasProperty(key)) {
            return defaultValue;
        }
        return this.getProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.map.put(key, value);
    }

    @Override
    public Object removeProperty(String key) {
        return this.map.remove(key);
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.map.keySet();
    }

    @Override
    public Map<String, Object> asMap() {
        return new HashMap<String, Object>(this.map);
    }

    @Override
    public void setPropertiesFrom(Map<String, Object> m) {
        this.map.clear();
        this.map.putAll(m);
        this.setDirty(true);
    }

    @Override
    public DynamicProperties createFrom(Map<String, Object> map) {
        return new DynamicPropertiesContainer(map);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

