/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;

public class ContainerConverter {
    public static <T, C extends Iterable<T>> C toContainer(Class<C> container, Iterable<T> data) {
        if (container.isInstance(data)) {
            return (C)data;
        }
        if (Iterable.class.equals(container)) {
            return (C)data;
        }
        if (SortedSet.class.isAssignableFrom(container)) {
            return (C)IteratorUtil.addToCollection(data, new TreeSet());
        }
        if (Set.class.isAssignableFrom(container)) {
            return (C)IteratorUtil.addToCollection(data, new HashSet());
        }
        List list = (List)IteratorUtil.addToCollection(data, new ArrayList(50));
        if (Page.class.isAssignableFrom(container)) {
            return (C)new PageImpl(list);
        }
        if (Slice.class.isAssignableFrom(container)) {
            return (C)new SliceImpl(list);
        }
        return (C)list;
    }

    public static <T> Slice<T> slice(Iterable<T> data, Pageable page) {
        int pageSize;
        Iterator<T> it = data.iterator();
        for (int offset = page.getOffset(); it.hasNext() && offset > 0; --offset) {
            it.next();
        }
        ArrayList<T> result = new ArrayList<T>(pageSize);
        for (pageSize = page.getPageSize(); it.hasNext() && pageSize > 0; --pageSize) {
            result.add(it.next());
        }
        return new SliceImpl(result, page, it.hasNext());
    }
}

