/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.Iterables;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.repository.query.CypherQuery;
import org.springframework.data.neo4j.support.query.QueryEngine;

public class LabelBasedStrategyCypherHelper {
    static final String CYPHER_ADD_LABEL_TO_NODE = "match (n) where id(n)={nodeId} set n:`%s`";
    static final String CYPHER_CREATE_MARKER_LABEL = "match (n) with n limit 1 set n:`%1$s` remove n:`%1$s` return count(*)";
    static final String CYPHER_ADD_LABELS_TO_NODE = "match (n) where id(n)={nodeId} set n%s";
    static final String CYPHER_COUNT_LABELS_ON_NODE = "match (n) where id(n)={nodeId} and n:`%s` return count(*) ";
    static final String CYPHER_RETURN_NODES_WITH_LABEL = "match (n:`%s`) return n";
    static final String CYPHER_RETURN_COUNT_OF_NODES_WITH_LABEL = "match (n:`%s`) return count(*)";
    static final String CYPHER_RETURN_LABELS_FOR_NODE = "match (n) where id(n)={nodeId} return labels(n) as labels";
    private QueryEngine<CypherQuery> queryEngine;

    public LabelBasedStrategyCypherHelper(QueryEngine<CypherQuery> queryEngine) {
        this.queryEngine = queryEngine;
    }

    public void setLabelOnNode(Long nodeId, String label) {
        String addLabelStatement = String.format(CYPHER_ADD_LABEL_TO_NODE, label);
        this.queryEngine.query(addLabelStatement, this.getParamsWithNodeId(nodeId));
    }

    public void createMarkerLabel(String label) {
        String addLabelStatement = String.format(CYPHER_CREATE_MARKER_LABEL, label);
        this.queryEngine.query(addLabelStatement, null);
    }

    public void setLabelsOnNode(Long nodeId, Collection<String> labelString) {
        String addLabelStatement = this.formatAddLabelString(labelString);
        this.queryEngine.query(addLabelStatement, this.getParamsWithNodeId(nodeId));
    }

    private String formatAddLabelString(Collection<String> labels) {
        return String.format(CYPHER_ADD_LABELS_TO_NODE, ":`" + Iterables.join((String)"`:`", labels) + "`");
    }

    public boolean doesNodeHaveLabel(Long nodeId, String label) {
        String query = String.format(CYPHER_COUNT_LABELS_ON_NODE, label);
        Result<CypherQuery> result = this.queryEngine.query(query, this.getParamsWithNodeId(nodeId));
        long labelCount = result.to(Number.class).single().longValue();
        return labelCount > 0L;
    }

    public Iterable<Node> getNodesWithLabel(String label) {
        String query = String.format(CYPHER_RETURN_NODES_WITH_LABEL, label);
        return this.queryEngine.query(query, Collections.EMPTY_MAP).to(Node.class);
    }

    public String buildLabelString(String ... labels) {
        String result = "";
        for (String label : labels) {
            result = result + ":`" + label + "`";
        }
        return result;
    }

    private Map<String, Object> getParamsWithNodeId(long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("nodeId", id);
        return params;
    }

    public long countNodesWithLabel(String label) {
        String query = String.format(CYPHER_RETURN_COUNT_OF_NODES_WITH_LABEL, label);
        Result<CypherQuery> result = this.queryEngine.query(query, Collections.EMPTY_MAP);
        return result.to(Number.class).single().longValue();
    }

    public Iterable<String> getLabelsForNode(long nodeId) {
        Map queryResult = this.queryEngine.query(CYPHER_RETURN_LABELS_FOR_NODE, this.getParamsWithNodeId(nodeId)).to(Map.class).single();
        return (Iterable)queryResult.get("labels");
    }
}

